/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jconnect.jira.customfields;

import com.atlassian.jconnect.jira.customfields.LocationParser;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.jira.util.NotNull;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operator.Operator;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Set;

public class LocationSearchClauseValidator
implements ClauseValidator {
    private final JqlOperandResolver operandResolver;
    private final Set<Operator> supported;
    final I18nHelper i18n;

    public LocationSearchClauseValidator(Set<Operator> supportedOperators, JqlOperandResolver operandResolver, I18nHelper i18n) {
        this.operandResolver = operandResolver;
        this.i18n = i18n;
        this.supported = (Set)Preconditions.checkNotNull(supportedOperators);
    }

    public MessageSet validate(ApplicationUser searcher, @NotNull TerminalClause terminalClause) {
        MessageSetImpl errors = new MessageSetImpl();
        if (!this.supported.contains(terminalClause.getOperator())) {
            errors.addErrorMessage(this.i18n.getText("customfields.locationsearcher.error.unsupportedoperator", terminalClause.getOperator().getDisplayString()));
        } else {
            this.validateOperand((MessageSet)errors, this.i18n, searcher, terminalClause);
        }
        return errors;
    }

    private void validateOperand(MessageSet errors, I18nHelper i18n, ApplicationUser searcher, TerminalClause terminalClause) {
        List literals = this.operandResolver.getValues(searcher, terminalClause.getOperand(), terminalClause);
        if (terminalClause.getOperator() == Operator.LIKE && literals != null) {
            if (literals.size() != 1) {
                errors.addErrorMessage(i18n.getText("customfields.locationsearcher.error.toomanyliterals", (Object)terminalClause));
                return;
            }
            for (QueryLiteral queryLiteral : literals) {
                LocationParser.validateAndParseLocationQuery(queryLiteral.getStringValue(), i18n, errors);
            }
        }
    }
}

