/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jconnect.jira.customfields;

import com.atlassian.jconnect.jira.customfields.BuiltInField;
import com.atlassian.jconnect.jira.customfields.CustomFieldHelper;
import com.atlassian.jira.issue.context.GlobalIssueContext;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.JiraContextNode;
import com.atlassian.jira.issue.context.ProjectContext;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenScheme;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenTab;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeEntity;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeManager;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.project.Project;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;

public class CustomFieldSchemeHelper {
    private final CustomFieldHelper customFieldHelper;
    private final IssueTypeSchemeManager issueTypeManager;
    private final IssueTypeScreenSchemeManager issueTypeScreenSchemeManager;
    private final FieldConfigSchemeManager fieldConfigSchemeManager;
    private final FieldScreenManager fieldScreenManager;
    private final FieldScreenSchemeManager fieldScreenSchemeManager;

    public CustomFieldSchemeHelper(CustomFieldHelper customFieldHelper, IssueTypeSchemeManager issueTypeManager, FieldConfigSchemeManager fieldConfigSchemeManager, FieldScreenManager fieldScreenManager, FieldScreenSchemeManager fieldScreenSchemeManager, IssueTypeScreenSchemeManager issueTypeScreenSchemeManager) {
        this.customFieldHelper = customFieldHelper;
        this.issueTypeManager = issueTypeManager;
        this.fieldConfigSchemeManager = fieldConfigSchemeManager;
        this.fieldScreenManager = fieldScreenManager;
        this.fieldScreenSchemeManager = fieldScreenSchemeManager;
        this.issueTypeScreenSchemeManager = issueTypeScreenSchemeManager;
    }

    public void toggleFieldsToProjectScheme(boolean addFields, Project project, BuiltInField ... fields) {
        List<String> issueTypeIds = this.issueTypeIdsFor(project);
        for (BuiltInField field : fields) {
            CustomField customField = this.customFieldHelper.initBuiltInCustomField(field);
            if (addFields) {
                if (!customField.isInScope(project, issueTypeIds)) {
                    this.addFieldToScheme(project, field, customField);
                }
                if (!field.isVisible()) continue;
                this.addToScreens(customField, project);
                continue;
            }
            this.removeFieldFromSchemeAndScreens(project, field, customField);
        }
        this.fieldScreenManager.refresh();
    }

    private void removeFieldFromSchemeAndScreens(Project project, BuiltInField field, CustomField customField) {
        List configSchemes = customField.getConfigurationSchemes();
        ProjectContext projectContext = new ProjectContext(project.getId());
        block0: for (FieldConfigScheme scheme : configSchemes) {
            List contextNodes = scheme.getContexts();
            if (contextNodes == null) continue;
            for (JiraContextNode contextNode : contextNodes) {
                if (contextNode instanceof GlobalIssueContext || !contextNode.isInContext((IssueContext)projectContext)) continue;
                this.fieldConfigSchemeManager.removeFieldConfigScheme(scheme.getId());
                continue block0;
            }
        }
        this.fieldConfigSchemeManager.removeSchemeAssociation(this.projectContext(project), (ConfigurableField)customField);
        this.fieldConfigSchemeManager.removeInvalidFieldConfigSchemesForCustomField(customField.getId());
    }

    private void addFieldToScheme(Project project, BuiltInField field, CustomField customField) {
        FieldConfigScheme scheme = this.fieldConfigSchemeManager.createDefaultScheme((ConfigurableField)customField, this.projectContext(project));
    }

    private void addToScreens(CustomField customField, Project project) {
        IssueTypeScreenScheme screenScheme = this.issueTypeScreenSchemeManager.getIssueTypeScreenScheme(project.getGenericValue());
        Collection issueTypeScreenSchemeEntities = screenScheme.getEntities();
        for (IssueTypeScreenSchemeEntity schemeEntity : issueTypeScreenSchemeEntities) {
            FieldScreenScheme fieldScreenScheme = schemeEntity.getFieldScreenScheme();
            FieldScreen fieldScreen = fieldScreenScheme.getFieldScreen((IssueOperation)IssueOperations.VIEW_ISSUE_OPERATION);
            if (fieldScreen == null || fieldScreen.getTabs().isEmpty() || fieldScreen.containsField(customField.getId())) continue;
            FieldScreenTab tab = (FieldScreenTab)fieldScreen.getTabs().iterator().next();
            tab.addFieldScreenLayoutItem(customField.getId());
        }
    }

    private List<JiraContextNode> projectContext(Project project) {
        return ImmutableList.of((Object)new ProjectContext(project.getId()));
    }

    List<String> issueTypeIdsFor(Project project) {
        return CustomFieldHelper.issueTypeIdsFor(project, this.issueTypeManager);
    }
}

