/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jconnect.jira;

import com.atlassian.jira.bc.user.UserService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.usercompatibility.UserCompatibilityHelper;
import com.atlassian.jira.usercompatibility.UserWithKey;
import com.google.common.base.Preconditions;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserHelper {
    private static final Logger log = LoggerFactory.getLogger(UserHelper.class);
    private static final String SYSTEM_USERNAME = "jiraconnectuser";
    private final UserService userService;
    private final UserManager userManager;

    public UserHelper(UserService userService, UserManager userManager) {
        this.userService = userService;
        this.userManager = userManager;
    }

    public ApplicationUser getJMCSystemUser() {
        String username = SYSTEM_USERNAME;
        log.debug("Retrieving user jiraconnectuser");
        return this.userManager.getUser(SYSTEM_USERNAME);
    }

    public UserWithKey getUser(String username) {
        return UserCompatibilityHelper.convertUserObject(this.userManager.getUserObject(username));
    }

    public ApplicationUser getApplicationUser(String username) {
        return this.userManager.getUserByKey(username);
    }

    public ApplicationUser getOrCreateJMCSystemUser() {
        ApplicationUser user = this.getJMCSystemUser();
        if (user == null) {
            String udid = SYSTEM_USERNAME;
            String password = UUID.randomUUID().toString();
            String email = "jiraconnectuser@connect.jira.com";
            String fullName = SYSTEM_USERNAME;
            UserService.CreateUserValidationResult validationResult = this.userService.validateCreateUserForSignup(null, this.asUsername(SYSTEM_USERNAME), password, password, "jiraconnectuser@connect.jira.com", SYSTEM_USERNAME);
            try {
                this.userService.createUserNoNotification(validationResult);
                log.debug("Created user: jiraconnectuser");
            }
            catch (Exception e) {
                log.error("Failed to create user", (Throwable)e);
                return null;
            }
            Preconditions.checkNotNull((Object)user, (Object)"user");
        }
        return user;
    }

    private String asUsername(String udid) {
        return udid.toLowerCase();
    }
}

