/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jconnect.jira;

import com.atlassian.jconnect.jira.JMCProjectService;
import com.atlassian.jconnect.jira.customfields.BuiltInField;
import com.atlassian.jconnect.jira.customfields.CustomFieldHelper;
import com.atlassian.jconnect.jira.customfields.CustomFieldSchemeHelper;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.propertyset.JiraPropertySetFactory;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.Query;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.UUID;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJMCProjectService
implements JMCProjectService {
    private final CustomFieldHelper customFieldHelper;
    private final CustomFieldSchemeHelper customFieldSchemeHelper;
    private final FieldManager fieldManager;
    private final JiraPropertySetFactory propertySetFactory;
    private final SearchService searchService;
    private final CustomFieldManager customFieldManager;
    private static final String PROPERTY_API_KEY = "jmc.api.key";
    private static final String PROPERTY_API_KEY_ENABLED = "jmc.api.key.enabled";
    private static final String PROPERTY_CRASHES_ENABLED = "jmc.crashes.enabled";
    private static final Logger log = LoggerFactory.getLogger(DefaultJMCProjectService.class);
    private final LoadingCache<Long, PropertySet> configCache = CacheBuilder.newBuilder().concurrencyLevel(8).build((CacheLoader)new CacheLoader<Long, PropertySet>(){

        public PropertySet load(@Nullable Long pid) {
            return DefaultJMCProjectService.this.propertySetFactory.buildCachingPropertySet("com.atlassian.jconnect.jconnect-plugin", pid, true);
        }
    });

    public DefaultJMCProjectService(CustomFieldHelper customFieldHelper, CustomFieldSchemeHelper customFieldSchemeHelper, FieldManager fieldManager, JiraPropertySetFactory propertySetFactory, SearchService searchService, CustomFieldManager customFieldManager) {
        this.customFieldHelper = customFieldHelper;
        this.customFieldSchemeHelper = customFieldSchemeHelper;
        this.fieldManager = fieldManager;
        this.propertySetFactory = propertySetFactory;
        this.searchService = searchService;
        this.customFieldManager = customFieldManager;
    }

    @Override
    public boolean reindexRequiredFor(Project project, ApplicationUser user) {
        Query query = JqlQueryBuilder.newBuilder().where().project().eq(project.getId()).buildQuery();
        try {
            return this.searchService.searchCount(user, query) > 0L;
        }
        catch (SearchException e) {
            log.warn(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public String generateApiKeyFor(Project project) {
        PropertySet propertySet = this.getPropertySet(project);
        return this.addApiKey(propertySet);
    }

    @Override
    public boolean toggleApiKeyFor(Project project, boolean enable) {
        PropertySet propertySet = this.getPropertySet(project);
        this.setApiKeyEnabledState(propertySet, enable);
        return enable;
    }

    @Override
    public boolean isApiKeyEnabledFor(Project project) {
        PropertySet propertySet = this.getPropertySet(project);
        return propertySet.getBoolean(PROPERTY_API_KEY_ENABLED);
    }

    @Override
    public boolean isCrashesEnabledFor(Project project) {
        PropertySet propertySet = this.getPropertySet(project);
        if (!propertySet.exists(PROPERTY_CRASHES_ENABLED)) {
            return true;
        }
        return propertySet.getBoolean(PROPERTY_CRASHES_ENABLED);
    }

    @Override
    public boolean toggleCrashesFor(Project project, boolean enable) {
        PropertySet propertySet = this.getPropertySet(project);
        propertySet.setBoolean(PROPERTY_CRASHES_ENABLED, enable);
        return enable;
    }

    @Override
    public String lookupApiKeyFor(Project project) {
        PropertySet propertySet = this.getPropertySet(project);
        return propertySet.getString(PROPERTY_API_KEY);
    }

    @Override
    public String generateOrRetrieveAPIKeyFor(Project project) {
        PropertySet propertySet = this.getPropertySet(project);
        this.setApiKeyEnabledState(propertySet, true);
        String currentKey = propertySet.getString(PROPERTY_API_KEY);
        if (currentKey == null) {
            currentKey = this.addApiKey(propertySet);
        }
        return currentKey;
    }

    private PropertySet getPropertySet(Project project) {
        return (PropertySet)this.configCache.getUnchecked((Object)project.getId());
    }

    private void setApiKeyEnabledState(PropertySet propertySet, boolean enable) {
        propertySet.setBoolean(PROPERTY_API_KEY_ENABLED, enable);
    }

    private String addApiKey(PropertySet propertySet) {
        String apiKey = UUID.randomUUID().toString();
        propertySet.setString(PROPERTY_API_KEY, apiKey);
        return apiKey;
    }

    @Override
    public synchronized boolean toggleForJiraConnect(Project project) {
        boolean isNowEnabled = !this.isJiraConnectProject(project);
        this.customFieldSchemeHelper.toggleFieldsToProjectScheme(isNowEnabled, project, BuiltInField.values());
        this.fieldManager.refresh();
        return this.isJiraConnectProject(project);
    }

    @Override
    public boolean isJiraConnectProject(Project project) {
        return this.customFieldHelper.containsAllFields(project, this.customFieldHelper.getAllBuiltInCustomFields());
    }

    @Override
    public long countJMCIssues(ApplicationUser user) {
        CustomField uuidField = this.customFieldManager.getCustomFieldObjectByName(BuiltInField.UUID.fieldName());
        Query query = JqlQueryBuilder.newBuilder().where().customField(uuidField.getIdAsLong()).notEqEmpty().buildQuery();
        try {
            return this.searchService.searchCount(user, query);
        }
        catch (SearchException e) {
            log.error(e.getMessage(), (Throwable)e);
            return -1L;
        }
    }
}

