(function($) {

    var global = window,
        JSONP_CALLBACK_NAME = "onJMCGMapsLoad";
        mapsCallbacks = [],
        googleLoaderRequested = false,
        googleMapsRequested = false;

    function runMapsCallbacks() {
        var cb;
        while (cb = mapsCallbacks.shift()) {
            cb();
        }
    }

    function loadMapAndRunCallbacks(callback) {
        var isGoogleMapsPresent = global.google.maps && global.google.maps.LatLng;

        if (isGoogleMapsPresent) {
            //Google Maps is here, run all the pending callbacks
            mapsCallbacks.push(callback);
            runMapsCallbacks();

        } else if (googleMapsRequested) {
            //Google Maps is not present but has been requested -> Add the callback to the maps queue,
            //it will be eventually executed by loadMapAndRunCallbacks()
            mapsCallbacks.push(callback);

        } else {
            //Google Maps is not present nor being requested -> Add the callback to the queue and request it
            googleMapsRequested = true;
            mapsCallbacks.push(callback);
            google.load("maps","3", {other_params:'sensor=false', callback: runMapsCallbacks} );
        }
    }

    function runWithGoogleMaps(callback) {
        if (global.google && global.google.load) {
            //Google Loader is present -> Load GMaps and run the callback
            loadMapAndRunCallbacks(callback);

        } else if (googleLoaderRequested) {
            //Google Loader is not present but has been requested -> Add the callback to the maps queue,
            //it will be eventually executed by loadMapAndRunCallbacks()
            mapsCallbacks.push(callback);

        } else {
            // Google Loader is not present nor requested -> Request it and add the callback to the maps queue
            googleLoaderRequested = true;
            global[JSONP_CALLBACK_NAME] = function() {
                loadMapAndRunCallbacks(callback);
            }
            var script = document.createElement("script");
            script.src = "https://www.google.com/jsapi?callback="+JSONP_CALLBACK_NAME;
            script.type = "text/javascript";
            $("body").append(script);
        }
    }

    function toggleMap(mapField) {
        if (mapField.hasClass("open")) {
            hideMap(mapField);
        } else {
            displayMap(mapField)
        }
    }

    function hideMap(mapField) {
        mapField.removeClass("open");
        mapShown = false;
    }

    function displayMap(mapField) {
        var mapDiv = mapField.find(".jConnectMap");

        mapField.addClass("open");
        mapShown = true;
        if (!map) {
            map = new google.maps.Map(mapDiv.get(0), {
                zoom: 8,
                center: geocodedLocation[1].geometry.location,
                mapTypeId: google.maps.MapTypeId.ROADMAP
            });

            new google.maps.Marker({
                map: map,
                position: geocodedLocation[1].geometry.location,
                title: geocodedLocation[1].formatted_address
            });
        }
    }

    var geocodedLocation,
        map,
        mapShown = false;

    JIRA.bind(JIRA.Events.NEW_CONTENT_ADDED, function (e, context, reason) {
        if (reason == "panelRefreshed" || reason == "pageLoad" ) {

            var mapField = $(".jConnectLocation.ready", context),
                anchor = mapField.find("> a"),
                location,
                geocoder;

            if (anchor.length) {
                runWithGoogleMaps(function() {
                    //Only bind events if not previously bound.
                    //As this code is asynchronous, previous check for the class ready was not enough
                    if (mapField.hasClass("ready")) {

                        location = new google.maps.LatLng(anchor.data('lat'), anchor.data('long'));
                        geocoder = new google.maps.Geocoder();
                        geocoder.geocode({
                            latLng: location
                        }, function(results, status) {
                            if (status == google.maps.GeocoderStatus.OK) {
                                geocodedLocation = results;
                                if (results[1]) {
                                    anchor.text(results[1].formatted_address);
                                }
                            }
                        });

                        mapField.removeClass("ready");
                        map = null; // previous map, if created, was replaced with new content
                        if (mapShown) {
                            displayMap(mapField);
                        }
                        anchor.click(function(e) {
                            e.preventDefault();
                            //Event can be attached multiple times. Prevent other handlers to avoid another
                            //call to toggleMap(), which effectively will hide the map
                            e.stopPropagation();
                            toggleMap(mapField);
                        });
                    }
                });
            };
        }
    });

})(AJS.$);