package com.atlassian.jconnect.rest.entities;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * Represents the status of a project in terms of JMC.
 */
@XmlRootElement(name = "jmcstatus")
@XmlAccessorType(XmlAccessType.FIELD)
public final class ProjectStatusEntity {
    @XmlAttribute
    private boolean enabled;
    @XmlAttribute
    private Long id;
    @XmlAttribute
    private String key;
    @XmlAttribute
    private String apiKey;
    @XmlAttribute
    private boolean apiKeyActive;
    @XmlAttribute
    private boolean crashesEnabled;
    @XmlAttribute
    private boolean reindex;

    private ProjectStatusEntity() { // for Jersey
    }

    public ProjectStatusEntity(Long id, String key, boolean enabled, String apiKey, boolean reindex, boolean apiKeyActive, boolean crashesEnabled) {
        this.id = id;
        this.key = key;
        this.apiKey = apiKey;
        this.enabled = enabled;
        this.reindex = reindex;
        this.apiKeyActive = apiKeyActive;
        this.crashesEnabled = crashesEnabled;
    }

    // Getters are used in velocity
    public boolean isEnabled() {
        return enabled;
    }

    public Long getId() {
        return id;
    }

    public String getKey() {
        return key;
    }

    public String getApiKey() {
        return apiKey;
    }

    public boolean isReindex() {
        return reindex;
    }

    public boolean isApiKeyActive() {
        return apiKeyActive;
    }

    public boolean isCrashesEnabled() {
        return crashesEnabled;
    }
}