package com.atlassian.jconnect.rest.entities;

import javax.xml.bind.annotation.*;
import java.util.Date;
import java.util.List;

@XmlRootElement(name = "issuesWithComment")
@XmlAccessorType(XmlAccessType.FIELD)
public class IssueWithCommentsEntity
{
    @XmlAttribute
    private String key;

    @XmlAttribute
    private String status;

    @XmlElement(name = "summary")
    private String summary;

    @XmlElement(name = "description")
    private String description;

    @XmlElement(name = "dateUpdated")
    private Date dateUpdated;

    // to prevent the need 
    @XmlElement(name = "hasUpdates")
    private boolean hasUpdates;

    @XmlElement(name = "dateCreated")
    private Date dateCreated;

    @XmlElement(name = "comments")
    private List<CommentEntity> comments;

    private IssueWithCommentsEntity()
    {
        // for jersey
    }

    public IssueWithCommentsEntity(String key, String status, String summary, String description, Date created, Date lastUpdated, List<CommentEntity> comments, boolean hasUpdates)
    {
        this.key = key;
        this.status = status;
        this.summary = summary;
        this.description = description;
        this.dateCreated = created;
        this.dateUpdated = lastUpdated;
        this.comments = comments;
        this.hasUpdates = hasUpdates;
    }

    public String getKey()
    {
        return key;
    }

    public String getStatus()
    {
        return status;
    }

    public String getSummary()
    {
        return summary;
    }
    public String getDescription()
    {
        return description;
    }

    public List<CommentEntity> getComments()
    {
        return comments;
    }

    public Date getDateCreated()
    {
        return dateCreated;
    }

    public Date getDateUpdated()
    {
        return dateUpdated;
    }

    public boolean isHasUpdates()
    {
        return hasUpdates;
    }


    public void setKey(String key) {
        this.key = key;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDateUpdated(Date dateUpdated) {
        this.dateUpdated = dateUpdated;
    }

    public void setHasUpdates(boolean hasUpdates) {
        this.hasUpdates = hasUpdates;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public void setComments(List<CommentEntity> comments) {
        this.comments = comments;
    }
}
