/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.integrationtesting.runner;

import com.atlassian.integrationtesting.runner.CompositeTestRunner;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import org.junit.runner.notification.RunListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RunListeners {
    private RunListeners() {
    }

    public static Function<CompositeTestRunner.BeforeTestClass, Void> addListener(RunListener listener) {
        return new AddListener(listener, (Predicate<CompositeTestRunner.BeforeTestClass>)Predicates.alwaysTrue());
    }

    public static Function<CompositeTestRunner.BeforeTestClass, Void> addListener(RunListener listener, Predicate<CompositeTestRunner.BeforeTestClass> predicate) {
        return new AddListener(listener, predicate);
    }

    public static Function<CompositeTestRunner.AfterTestClass, Void> removeListener(RunListener listener) {
        return new RemoveListener(listener);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RemoveListener
    implements Function<CompositeTestRunner.AfterTestClass, Void> {
        private final RunListener listener;

        public RemoveListener(RunListener listener) {
            this.listener = listener;
        }

        public Void apply(CompositeTestRunner.AfterTestClass test) {
            if (this.listener != null) {
                test.notifier.removeListener(this.listener);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AddListener
    implements Function<CompositeTestRunner.BeforeTestClass, Void> {
        private final RunListener listener;
        private final Predicate<CompositeTestRunner.BeforeTestClass> predicate;

        public AddListener(RunListener listener, Predicate<CompositeTestRunner.BeforeTestClass> predicate) {
            this.listener = listener;
            this.predicate = predicate;
        }

        public Void apply(CompositeTestRunner.BeforeTestClass test) {
            if (this.predicate.apply((Object)test)) {
                test.notifier.addListener(this.listener);
            }
            return null;
        }
    }
}

