/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.integrationtesting.runner;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.lang.annotation.Annotation;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompositeTestRunner
extends BlockJUnit4ClassRunner {
    private final Predicate<TestClass> shouldRunTestsInClass;
    private final Iterable<Function<BeforeTestClass, Void>> beforeTestClass;
    private final Iterable<Function<AfterTestClass, Void>> afterTestClass;
    private final Predicate<FrameworkMethod> shouldRunTestMethod;
    private final Iterable<Function<BeforeTestMethod, Void>> beforeTestMethod;
    private final Iterable<Function<AfterTestMethod, Void>> afterTestMethod;
    private final ThreadLocal<RunNotifier> notifier = new ThreadLocal();

    public CompositeTestRunner(Class<?> klass, Composer composer) throws InitializationError {
        super(klass);
        this.shouldRunTestsInClass = Predicates.and((Iterable)composer.shouldRunTestsInClass);
        this.shouldRunTestMethod = Predicates.and((Iterable)composer.shouldRunTestMethod);
        this.beforeTestClass = composer.beforeTestClass;
        this.afterTestClass = composer.afterTestClass;
        this.beforeTestMethod = composer.beforeTestMethod;
        this.afterTestMethod = composer.afterTestMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run(RunNotifier notifier) {
        if (this.shouldRunTestsInClass.apply((Object)this.getTestClass())) {
            this.notifier.set(notifier);
            try {
                super.run(notifier);
            }
            finally {
                this.notifier.set(null);
            }
        } else {
            notifier.fireTestIgnored(this.getDescription());
        }
    }

    protected final void runChild(FrameworkMethod method, RunNotifier notifier) {
        EachTestNotifier eachNotifier = this.makeNotifier(method, notifier);
        if (this.shouldRunTestMethod.apply((Object)method)) {
            super.runChild(method, notifier);
        } else {
            eachNotifier.fireTestIgnored();
        }
    }

    protected final Statement withBefores(final FrameworkMethod method, final Object target, Statement statement) {
        final Statement next = super.withBefores(method, target, statement);
        return new Statement(){

            public void evaluate() throws Throwable {
                CompositeTestRunner.this.applyAll(CompositeTestRunner.this.beforeTestMethod, new BeforeTestMethod(CompositeTestRunner.this.getTestClass(), method, (RunNotifier)CompositeTestRunner.this.notifier.get(), target));
                next.evaluate();
            }
        };
    }

    protected final Statement withAfters(final FrameworkMethod method, final Object target, Statement statement) {
        final Statement next = super.withAfters(method, target, statement);
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                try {
                    next.evaluate();
                }
                finally {
                    CompositeTestRunner.this.applyAll(CompositeTestRunner.this.afterTestMethod, new AfterTestMethod(CompositeTestRunner.this.getTestClass(), method, (RunNotifier)CompositeTestRunner.this.notifier.get(), target));
                }
            }
        };
    }

    protected final Statement withBeforeClasses(Statement statement) {
        final Statement next = super.withBeforeClasses(statement);
        return new Statement(){

            public void evaluate() throws Throwable {
                CompositeTestRunner.this.applyAll(CompositeTestRunner.this.beforeTestClass, new BeforeTestClass(CompositeTestRunner.this.getTestClass(), (RunNotifier)CompositeTestRunner.this.notifier.get()));
                next.evaluate();
            }
        };
    }

    protected final Statement withAfterClasses(Statement statement) {
        final Statement next = super.withAfterClasses(statement);
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                try {
                    next.evaluate();
                }
                finally {
                    CompositeTestRunner.this.applyAll(CompositeTestRunner.this.afterTestClass, new AfterTestClass(CompositeTestRunner.this.getTestClass(), (RunNotifier)CompositeTestRunner.this.notifier.get()));
                }
            }
        };
    }

    private <T> void applyAll(Iterable<Function<T, Void>> fs, T t) {
        for (Function<T, Void> f : fs) {
            f.apply(t);
        }
    }

    private EachTestNotifier makeNotifier(FrameworkMethod method, RunNotifier notifier) {
        Description description = this.describeChild(method);
        return new EachTestNotifier(notifier, description);
    }

    public static Composer compose() {
        return new Composer((Iterable)ImmutableList.of(), (Iterable)ImmutableList.of(), (Iterable)ImmutableList.of(), (Iterable)ImmutableList.of(), (Iterable)ImmutableList.of(), (Iterable)ImmutableList.of());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class AfterTestMethod {
        public final TestClass testClass;
        public final FrameworkMethod method;
        public final RunNotifier notifier;
        public final Object target;

        private AfterTestMethod(TestClass testClass, FrameworkMethod method, RunNotifier notifier, Object target) {
            this.testClass = testClass;
            this.method = method;
            this.notifier = notifier;
            this.target = target;
        }

        public boolean hasAnnotation(Class<? extends Annotation> cls) {
            return this.method.getAnnotation(cls) != null || this.method.getMethod().getDeclaringClass().isAnnotationPresent(cls);
        }

        public <T extends Annotation> T getAnnotation(Class<T> cls) {
            if (this.method.getAnnotation(cls) != null) {
                return (T)this.method.getAnnotation(cls);
            }
            return this.method.getMethod().getDeclaringClass().getAnnotation(cls);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class BeforeTestMethod {
        public final TestClass testClass;
        public final FrameworkMethod method;
        public final RunNotifier notifier;
        public final Object target;

        private BeforeTestMethod(TestClass testClass, FrameworkMethod method, RunNotifier notifier, Object target) {
            this.testClass = testClass;
            this.method = method;
            this.notifier = notifier;
            this.target = target;
        }

        public boolean hasAnnotation(Class<? extends Annotation> cls) {
            return this.method.getAnnotation(cls) != null || this.method.getMethod().getDeclaringClass().isAnnotationPresent(cls);
        }

        public <T extends Annotation> T getAnnotation(Class<T> cls) {
            if (this.method.getAnnotation(cls) != null) {
                return (T)this.method.getAnnotation(cls);
            }
            return this.method.getMethod().getDeclaringClass().getAnnotation(cls);
        }
    }

    public static final class AfterTestClass {
        public final TestClass testClass;
        public final RunNotifier notifier;

        public AfterTestClass(TestClass testClass, RunNotifier notifier) {
            this.testClass = testClass;
            this.notifier = notifier;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class BeforeTestClass {
        public final TestClass testClass;
        public final RunNotifier notifier;

        public BeforeTestClass(TestClass testClass, RunNotifier notifier) {
            this.testClass = testClass;
            this.notifier = notifier;
        }

        public boolean hasAnnotation(Class<? extends Annotation> cls) {
            return this.testClass.getJavaClass().isAnnotationPresent(cls);
        }

        public <T extends Annotation> T getAnnotation(Class<T> cls) {
            return this.testClass.getJavaClass().getAnnotation(cls);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Composer {
        private final Iterable<Predicate<TestClass>> shouldRunTestsInClass;
        private final Iterable<Function<BeforeTestClass, Void>> beforeTestClass;
        private final Iterable<Function<AfterTestClass, Void>> afterTestClass;
        private final Iterable<Predicate<FrameworkMethod>> shouldRunTestMethod;
        private final Iterable<Function<BeforeTestMethod, Void>> beforeTestMethod;
        private final Iterable<Function<AfterTestMethod, Void>> afterTestMethod;

        private Composer(Iterable<Predicate<TestClass>> shouldRunTestsInClass, Iterable<Function<BeforeTestClass, Void>> beforeTestClass, Iterable<Function<AfterTestClass, Void>> afterTestClass, Iterable<Predicate<FrameworkMethod>> shouldRunTestMethod, Iterable<Function<BeforeTestMethod, Void>> beforeTestMethod, Iterable<Function<AfterTestMethod, Void>> afterTestMethod) {
            this.shouldRunTestsInClass = shouldRunTestsInClass;
            this.beforeTestClass = beforeTestClass;
            this.afterTestClass = afterTestClass;
            this.shouldRunTestMethod = shouldRunTestMethod;
            this.beforeTestMethod = beforeTestMethod;
            this.afterTestMethod = afterTestMethod;
        }

        public Composer shouldRunTestsInClass(Predicate<TestClass> p) {
            return new Composer(Iterables.concat(this.shouldRunTestsInClass, (Iterable)ImmutableList.of(p)), this.beforeTestClass, this.afterTestClass, this.shouldRunTestMethod, this.beforeTestMethod, this.afterTestMethod);
        }

        public Composer beforeTestClass(Function<BeforeTestClass, Void> f) {
            return new Composer(this.shouldRunTestsInClass, Iterables.concat(this.beforeTestClass, (Iterable)ImmutableList.of(f)), this.afterTestClass, this.shouldRunTestMethod, this.beforeTestMethod, this.afterTestMethod);
        }

        public Composer afterTestClass(Function<AfterTestClass, Void> f) {
            return new Composer(this.shouldRunTestsInClass, this.beforeTestClass, Iterables.concat(this.afterTestClass, (Iterable)ImmutableList.of(f)), this.shouldRunTestMethod, this.beforeTestMethod, this.afterTestMethod);
        }

        public Composer shouldRunTestMethod(Predicate<FrameworkMethod> p) {
            return new Composer(this.shouldRunTestsInClass, this.beforeTestClass, this.afterTestClass, Iterables.concat(this.shouldRunTestMethod, (Iterable)ImmutableList.of(p)), this.beforeTestMethod, this.afterTestMethod);
        }

        public Composer beforeTestMethod(Function<BeforeTestMethod, Void> f) {
            return new Composer(this.shouldRunTestsInClass, this.beforeTestClass, this.afterTestClass, this.shouldRunTestMethod, Iterables.concat(this.beforeTestMethod, (Iterable)ImmutableList.of(f)), this.afterTestMethod);
        }

        public Composer afterTestMethod(Function<AfterTestMethod, Void> f) {
            return new Composer(this.shouldRunTestsInClass, this.beforeTestClass, this.afterTestClass, this.shouldRunTestMethod, this.beforeTestMethod, Iterables.concat(this.afterTestMethod, (Iterable)ImmutableList.of(f)));
        }

        public Composer from(Composer composer) {
            return new Composer(Iterables.concat(this.shouldRunTestsInClass, composer.shouldRunTestsInClass), Iterables.concat(this.beforeTestClass, composer.beforeTestClass), Iterables.concat(this.afterTestClass, composer.afterTestClass), Iterables.concat(this.shouldRunTestMethod, composer.shouldRunTestMethod), Iterables.concat(this.beforeTestMethod, composer.beforeTestMethod), Iterables.concat(this.afterTestMethod, composer.afterTestMethod));
        }
    }
}

