/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.integrationtesting.runner;

import com.atlassian.integrationtesting.ApplicationPropertiesProvidingModule;
import com.atlassian.integrationtesting.runner.CompositeTestRunner;
import com.atlassian.sal.api.ApplicationProperties;
import com.google.common.base.Function;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Scopes;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.junit.runner.Description;
import org.junit.runner.notification.RunListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApplicationLogDelimiter
extends RunListener {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationLogDelimiter.class);
    private final ApplicationProperties applicationProperties;
    private final HttpClient client = new DefaultHttpClient();

    @Inject
    ApplicationLogDelimiter(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    public static CompositeTestRunner.Composer compose(ApplicationProperties applicationProperties) {
        Injector injector = Guice.createInjector((Module[])new Module[]{new ApplicationPropertiesProvidingModule(applicationProperties)});
        return ApplicationLogDelimiter.compose(injector);
    }

    public static CompositeTestRunner.Composer compose(Injector injector) {
        Injector child = injector.createChildInjector(new Module[]{new LogDelimiterModule()});
        return CompositeTestRunner.compose().beforeTestClass(new LogDelimiterBefore(child)).afterTestClass(new LogDelimiterAfter(child));
    }

    public void testStarted(Description description) throws Exception {
        this.post(State.TEST_STARTED, description.getDisplayName());
    }

    public void testFinished(Description description) throws Exception {
        this.post(State.TEST_FINISHED, description.getDisplayName());
    }

    private void post(State state, String name) {
        HttpPost post = new HttpPost(this.applicationProperties.getBaseUrl() + "/rest/ait/1.0/test-log");
        post.setEntity(ApplicationLogDelimiter.form(ApplicationLogDelimiter.pair("state", state.toString()), ApplicationLogDelimiter.pair("test", name)));
        try {
            HttpResponse response = this.client.execute((HttpUriRequest)post);
            if (response.getEntity() != null) {
                response.getEntity().consumeContent();
            }
        }
        catch (ClientProtocolException e) {
            logger.error("Could not log test state", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Could not log test state", (Throwable)e);
        }
    }

    private static final HttpEntity form(NameValuePair ... parameters) {
        try {
            return new UrlEncodedFormEntity(Arrays.asList(parameters));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static final NameValuePair pair(String name, String value) {
        return new BasicNameValuePair(name, value);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LogDelimiterAfter
    implements Function<CompositeTestRunner.AfterTestClass, Void> {
        private final Injector injector;

        public LogDelimiterAfter(Injector injector) {
            this.injector = injector;
        }

        public Void apply(CompositeTestRunner.AfterTestClass test) {
            test.notifier.removeListener((RunListener)this.injector.getInstance(ApplicationLogDelimiter.class));
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LogDelimiterBefore
    implements Function<CompositeTestRunner.BeforeTestClass, Void> {
        private final Injector injector;

        public LogDelimiterBefore(Injector injector) {
            this.injector = injector;
        }

        public Void apply(CompositeTestRunner.BeforeTestClass test) {
            test.notifier.addListener((RunListener)this.injector.getInstance(ApplicationLogDelimiter.class));
            return null;
        }
    }

    private static final class LogDelimiterModule
    extends AbstractModule {
        private LogDelimiterModule() {
        }

        protected void configure() {
            this.bind(ApplicationLogDelimiter.class).in(Scopes.SINGLETON);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        TEST_STARTED,
        TEST_FINISHED;

    }
}

