package com.atlassian.integrationtesting.runner.restore;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * <p>Specify the backup file that will be imported into the application.  Unlike {@link Restore}, this annotation can
 * only appear on classes.  When this annotation does appear on classes the backup file is imported once before any
 * test methods are executed, with one exception.</p>
 * 
 * <p>If there is a test method annotated with {@code Restore} inside a class annotated with {@code RestoreOnce}, then
 * the backup file specified by the {@code RestoreOnce} is re-imported after the test method is run to ensure that
 * the application is in a known state for other tests in the class.</p>
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface RestoreOnce
{
    String value();
    
    String user() default "admin";
}
