package com.atlassian.integrationtesting;


import com.google.common.base.Function;

public final class Functions
{
    public static <A, B> Functions.Function0<B> partiallyApply(final Function<A, B> f, final A a)
    {
        return new Functions.Function0<B>()
        {
            public B apply()
            {
                return f.apply(a);
            }
        };
    }

    public interface Function0<A>
    {
        A apply();
    }
}
