package com.atlassian.integrationtesting;

import java.io.File;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;

import com.atlassian.sal.api.ApplicationProperties;

public final class ApplicationPropertiesImpl implements ApplicationProperties
{
    /**
     * An {@code ApplicationProperties} implementation used for testing that uses the canonical base URL for the server
     * under test.
     * <p/>
     * This uses the {@code baseurl} system property, if set, or defaults to {@code http://localhost:3990/it} if
     * the system property is missing.
     */
    private static final ApplicationProperties STANDARD = new ApplicationPropertiesImpl(getStandardBaseUrl());

    private final String baseUrl;

    public ApplicationPropertiesImpl(String baseUrl)
    {
        this.baseUrl = baseUrl;
    }

    public static ApplicationProperties getStandardApplicationProperties()
    {
        return STANDARD;
    }

    private static String getStandardBaseUrl()
    {
        return System.getProperty("baseurl", "http://localhost:3990/it");
    }

    public String getBaseUrl()
    {
        return baseUrl;
    }

    public String getDisplayName()
    {
        return "Atlassian Integration Tester";
    }

    public String getVersion()
    {
        return System.getProperty("version");
    }

    public Date getBuildDate()
    {
        final String timestamp = System.getProperty("timestamp");
        if (timestamp != null)
        {
            try
            {
                return DateFormat.getDateTimeInstance().parse(timestamp);
            }
            catch (ParseException e)
            {
                return null;
            }
        }
        return null;
    }

    public String getBuildNumber()
    {
        return System.getProperty("buildNumber");
    }

    public File getHomeDirectory()
    {
        return null;
    }
}
