/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.integration.jira.element;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.query.webdriver.GenericWebDriverTimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.integration.jira.element.JiraTransitionField;
import com.google.inject.Inject;
import java.util.List;
import org.openqa.selenium.By;

public class JiraAllowedValuesField
implements JiraTransitionField {
    @Inject
    protected PageElementFinder elementFinder;
    private final PageElement selectInput;

    public JiraAllowedValuesField(PageElement input) {
        this.selectInput = input;
    }

    @Override
    public String getValue() {
        return this.selectInput.getValue();
    }

    @Override
    public void setValue(String value) {
        List options = this.elementFinder.findAll(By.className((String)"select2-result"));
        for (PageElement option : options) {
            String optionText = option.find(By.className((String)"select2-result-label")).withTimeout(TimeoutType.SLOW_PAGE_LOAD).getText();
            if (!value.equalsIgnoreCase(optionText)) continue;
            option.withTimeout(TimeoutType.UI_ACTION).click();
            return;
        }
    }

    public void waitUntilOptionsAvailable() {
        Poller.waitUntilTrue((TimedQuery)new GenericWebDriverTimedQuery(() -> {
            List options = this.elementFinder.findAll(By.cssSelector((String)"select > option"));
            if (options.size() > 0) {
                return true;
            }
            throw new GenericWebDriverTimedQuery.InvalidValue((Object)false);
        }, 20000L));
    }
}

