package com.atlassian.webdriver.integration.jira.element.internal;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.google.common.base.Supplier;
import org.openqa.selenium.JavascriptExecutor;

import javax.inject.Inject;

import static com.atlassian.pageobjects.elements.query.Poller.waitUntilTrue;

/**
 * * Page Object for UPM web login
 * Stolen from Applinks Page Objects, and made to work with Jira 6.0.6.
 * Also made to not flake out
 */
public class WebLoginPage {
    public static final String USERNAME_FIELD_NAME = "os_username";

    @Inject
    protected JavascriptExecutor javascriptExecutor;

    @Inject
    protected Timeouts timeouts;

    @Inject
    private PageElementFinder elementFinder;

    @ElementBy(name = USERNAME_FIELD_NAME)
    private PageElement usernameField;

    @ElementBy(name = "os_password")
    private PageElement passwordField;

    @ElementBy(name = "login")
    private PageElement submitButton;

    public TimedCondition isShowing() {
        return usernameField.timed().isPresent();
    }

    public void handleWebLoginIfRequired(String username, String password) {
        if (usernameField.isPresent()) {
            usernameField.type(username);
            passwordField.type(password);
            waitForPagePop(new Runnable() {

                @Override
                public void run() {
                    submitButton.click();
                }
            });
        }

        if (usernameField.isPresent()) {
            throw new IllegalStateException("should already be logged in by now");
        }
    }

    private void waitForPagePop(Runnable runnable) {
        javascriptExecutor.executeScript("window.pagePopExpected = true;");
        runnable.run();
        waitUntilTrue(Queries.forSupplier(timeouts, new Supplier<Boolean>() {
            @Override
            public Boolean get() {
                return (Boolean) javascriptExecutor.executeScript("return window && window.pagePopExpected !== true;");
            }
        }));
    }
}
