package com.atlassian.webdriver.integration.jira.element;


import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import org.openqa.selenium.By;

public class JiraTransitionForm extends JiraForm {

    private final JiraIssuesDialog parent;

    public JiraTransitionForm(PageElement container, JiraIssuesDialog parent) {
        super(container);
        this.parent = parent;
    }

    public JiraIssuePanel submit() {
        PageElement submitButton = container.find(By.className("jira-transition"));
        scrollTo(submitButton);
        submitButton.click();
        Poller.waitUntilFalse(isShowing());
        return parent.getIssuePanel();
    }

}
