package com.atlassian.webdriver.integration.jira.element;

import com.atlassian.pageobjects.elements.PageElement;

public class JiraTextareaField implements JiraTransitionField {

    private final PageElement textInput;

    public JiraTextareaField(PageElement input) {
        textInput = input;
    }

    @Override
    public String getValue() {
        return textInput.getValue();
    }

    @Override
    public void setValue(String val) {
        textInput.clear();
        textInput.type(val);
    }
}
