package com.atlassian.webdriver.integration.jira.element;

import com.atlassian.pageobjects.elements.PageElement;
import org.openqa.selenium.Keys;

import java.util.List;

public class JiraTextField implements JiraTransitionField {

    private final PageElement textInput;

    public JiraTextField(PageElement input) {
        textInput = input;
    }

    @Override
    public String getValue() {
        return textInput.getValue();
    }

    @Override
    public void setValue(String val) {
        textInput.clear();
        textInput.type(val);
        textInput.type(Keys.TAB);
    }

    public void setValue(List<String> values) {
        textInput.clear();

        values.forEach(val -> {
            textInput.type(val);
            textInput.type(" ");
        });

        textInput.type(Keys.TAB);
    }

    public boolean isValid() {
        String validationState = textInput.getAttribute("data-aui-validation-state");
        return validationState == null || validationState.equals("valid");
    }
}
