package com.atlassian.webdriver.integration.jira.element;

import com.atlassian.aui.auipageobjects.AuiCheckbox;
import com.atlassian.pageobjects.elements.PageElement;
import org.openqa.selenium.By;

public class JiraRadioButtonsField implements JiraTransitionField {

    private final PageElement fieldset;

    public JiraRadioButtonsField(PageElement input) {
        fieldset = input;
    }

    @Override
    public String getValue() {
        return fieldset.getValue();
    }

    @Override
    public void setValue(String val) {
        fieldset.find(By.cssSelector("input.radio[value=\"" + val + "\"]"), AuiCheckbox.class).click();
    }
}
