package com.atlassian.webdriver.integration.jira.element;

import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import org.openqa.selenium.By;

public class JiraIssuesDialog extends JiraDialog {
    public JiraIssuesDialog(By locator) {
        super(locator);
    }

    public TimedCondition isShowing(String issueKey) {
        return getIssuePanel().isShowing(issueKey);
    }

    public void waitUntilDetailsShown() {
        Poller.waitUntilTrue(root.find(By.className("jira-issue-detailed"), TimeoutType.SLOW_PAGE_LOAD).timed().isVisible());
    }

    public JiraIssuePanel getIssuePanel() {
        waitUntilDetailsShown();
        return pageBinder.bind(JiraIssuePanel.class, root.find(By.className("jira-issue-detailed")), this);
    }

    public JiraTransitionForm getTransitionForm() {
        return pageBinder.bind(JiraTransitionForm.class, root.find(By.className("jira-transition-form")), this);
    }

    public JiraIssuesDialog goToNextIssue() {
        String key = getIssuePanel().getIssueKey();
        driver.findElement(By.tagName("body")).sendKeys("j");
        Poller.waitUntilFalse(isShowing(key));
        waitUntilDetailsShown();

        return this;
    }

    public JiraIssuesDialog goToPreviousIssue() {
        String key = getIssuePanel().getIssueKey();
        driver.findElement(By.tagName("body")).sendKeys("k");
        Poller.waitUntilFalse(isShowing(key));
        waitUntilDetailsShown();

        return this;
    }

    @Override
    protected By getCancelButtonLocator() {
        return By.className("button-panel-cancel-link");
    }
}
