package com.atlassian.webdriver.integration.jira.element;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import org.openqa.selenium.By;

import javax.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

import static com.atlassian.pageobjects.elements.timeout.TimeoutType.PAGE_LOAD;

public class JiraIssueList {
    private final PageElement container;

    @Inject
    private Timeouts timeouts;

    public JiraIssueList(PageElement container) {
        this.container = container;
    }

    public TimedCondition isJiraIssueListVisible() {
        return container.withTimeout(TimeoutType.SLOW_PAGE_LOAD).timed().isVisible();
    }

    public TimedQuery<List<String>> getJiraIssueKeys() {
        if (!container.timed().isVisible().byDefaultTimeout()) {
            return Queries.forSupplier(timeouts, Collections::emptyList);
        }

        return Queries.forSupplier(timeouts, () -> container.findAll(By.className("issue-item"))
                .stream()
                .map(e -> e.find(By.tagName("a")).getAttribute("data-issuekey"))
                .collect(Collectors.toList()), PAGE_LOAD);
    }

}
