package com.atlassian.webdriver.integration.jira.element;

import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.binder.Init;
import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.integration.jira.element.internal.OAuthConfirmPage;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;

import javax.inject.Inject;

abstract public class JiraDialog {
    protected final By locator;

    @Inject
    protected WebDriver driver;

    @Inject
    protected PageBinder pageBinder;

    protected PageElement root;

    @Inject
    protected PageElementFinder elementFinder;

    public JiraDialog(By locator) {
        this.locator = locator;
    }

    public JiraDialog completeOAuthDance(String jiraUsername, String jiraPassword) {
        waitUntilAuthenticationMessageShown();
        String currentWindowHandle = driver.getWindowHandle();
        root.find(By.className("applink-authenticate"), TimeoutType.AJAX_ACTION).click();

        return (JiraDialog) pageBinder.bind(OAuthConfirmPage.class, this).confirmHandlingWebLoginIfRequired(currentWindowHandle, jiraUsername, jiraPassword);
    }

    public void waitUntilAuthenticationMessageShown() {
        Poller.waitUntilTrue(root.find(By.className("applink-authenticate"), TimeoutType.SLOW_PAGE_LOAD).timed().isVisible());
    }

    public TimedCondition isOpen() {
        return root.find(By.className("dialog-components"), TimeoutType.DIALOG_LOAD).timed().isVisible();
    }

    public void waitUntilErrorsShown() {
        Poller.waitUntilTrue(root.find(By.className("jira-dialog-message"), TimeoutType.AJAX_ACTION).timed().isVisible());
    }

    public void close() {
        waitUntilOpen();
        root.find(getCancelButtonLocator()).click();
        waitUntilClosed();
    }

    abstract protected By getCancelButtonLocator();

    protected void waitUntilClosed() {
        Poller.waitUntilFalse(isOpen());
    }

    @WaitUntil
    protected void waitUntilOpen() {
        initRoot(); // can't be done in @init because WaitUntil happens first
        Poller.waitUntilTrue(isOpen());
    }

    @Init
    private void initRoot() {
        if (root == null) {
            root = elementFinder.find(locator);
        }
    }
}
