package com.atlassian.webdriver.integration.jira.element;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import org.openqa.selenium.By;

public class JiraCreateIssueDialog extends JiraDialog {
    private static final String CREATE_ISSUE_TEXT = "Create issue";
    private static final String CONTAINER_ID = "[data-testid='client-extensions-modal']";

    public JiraCreateIssueDialog() {
        super(By.cssSelector(CONTAINER_ID));
    }

    @Override
    public TimedCondition isOpen() {
        return root.find(By.className("jira-create-form"), TimeoutType.DIALOG_LOAD).timed().isVisible();
    }

    public TimedCondition hasProjectSelector() {
        return root.find(By.className("project-select"), TimeoutType.AJAX_ACTION).timed().isVisible();
    }

    private PageElement getCreateButton() {
        return root.find(By.xpath("//*[.=('" + CREATE_ISSUE_TEXT + "')]"));
    }

    public void createIssue(boolean expectSuccess) {
        PageElement createButton = getCreateButton();
        Poller.waitUntilTrue(createButton.timed().isEnabled());
        createButton.click();
        if (expectSuccess) {
            Poller.waitUntilFalse(isOpen());
        }
    }

    public JiraCreateIssueForm getForm() {
        return pageBinder.bind(JiraCreateIssueForm.class, root.find(By.className("jira-create-form")), this);
    }

    @Override
    protected By getCancelButtonLocator() {
        return By.className("cancel-button");
    }
}
