package com.atlassian.webdriver.integration.jira.element;

import com.atlassian.aui.auipageobjects.AuiCheckbox;
import com.atlassian.pageobjects.elements.PageElement;
import org.openqa.selenium.By;

import java.util.List;

public class JiraCheckboxesField implements JiraTransitionField {
    private final PageElement fieldset;

    public JiraCheckboxesField(PageElement input) {
        fieldset = input;
    }

    @Override
    public String getValue() {
        return fieldset.getValue();
    }

    @Override
    public void setValue(String val) {
        fieldset.find(By.cssSelector("input.checkbox[value=\"" + val + "\"]"), AuiCheckbox.class).click();
    }

    public void setValue(List<String> values) {
        values.forEach(this::setValue);
    }
}
