package com.atlassian.webdriver.integration.jira.element;

import com.atlassian.pageobjects.elements.PageElement;
import org.openqa.selenium.By;

import java.util.List;
import java.util.NoSuchElementException;

public class JiraAssigneeField extends JiraAutoCompleteField {

    public JiraAssigneeField(PageElement container, By hiddenSelector, PageElement pageRoot) {
        super(container, hiddenSelector, pageRoot);
    }

    @Override
    public void setValue(String val) {
        PageElement popup = performSearch(val);

        // we need to find our item, the field may contain "Automatic" and "Unassigned"
        List<PageElement> items = popup.findAll(By.cssSelector(".select2-results li"));
        PageElement searchedItem = items.stream()
                .filter(elem -> {
                    PageElement span = elem.find(By.cssSelector(".select2-result-label > span"));
                    String name = span.getAttribute("data-value");
                    return name != null && name.startsWith(val);
                })
                .findFirst()
                .orElseThrow(() -> new NoSuchElementException(val));

        searchedItem.click();
    }
}
