package com.atlassian.webdriver.integration.jira.element;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.webdriver.GenericWebDriverTimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.google.inject.Inject;
import org.openqa.selenium.By;

import java.util.List;

public class JiraAllowedValuesField implements JiraTransitionField {

    @Inject
    protected PageElementFinder elementFinder;

    private final PageElement selectInput;

    public JiraAllowedValuesField(PageElement input) {
        selectInput = input;
    }

    @Override
    public String getValue() {
        return selectInput.getValue();
    }

    @Override
    public void setValue(String value) {
        // The selection dropdown elements are in a separate area and not in the selectInput element.
        List<PageElement> options = elementFinder.findAll(By.className("select2-result"));
        for (PageElement option : options) {
            // Our value to match on is found in the label's text only.
            String optionText =
                    option.find(By.className("select2-result-label")).withTimeout(TimeoutType.SLOW_PAGE_LOAD).getText();
            if (value.equalsIgnoreCase(optionText)) {
                option.withTimeout(TimeoutType.UI_ACTION).click();
                return;
            }
        }
    }

    /**
     * This will wait until there is at least one option to select from in the dropdown.
     * Note that this is only effective when waiting for the initial population of a field,
     * subsequent updates won't always clear out the list of options before updating.
     */
    public void waitUntilOptionsAvailable() {
        Poller.waitUntilTrue(new GenericWebDriverTimedQuery<>(() -> {
            List<PageElement> options = elementFinder.findAll(By.cssSelector("select > option"));
            if (options.size() > 0) {
                return true;
            }
            // no options or the only option is a placeholder
            throw new GenericWebDriverTimedQuery.InvalidValue(false);
        }, 20_000L));
    }
}
