/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.integration.jira.element;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.webdriver.integration.jira.element.JiraTransitionField;
import com.google.common.collect.Lists;
import java.util.List;
import org.openqa.selenium.By;

public class JiraAllowedValuesField
implements JiraTransitionField {
    private final PageElement selectInput;
    private boolean isMultiple;

    public JiraAllowedValuesField(PageElement input) {
        this.selectInput = input;
        this.isMultiple = this.selectInput.getAttribute("multiple") != null;
    }

    @Override
    public String getValue() {
        return this.selectInput.getValue();
    }

    @Override
    public void setValue(String val) {
        this.setValue(val == null ? null : Lists.newArrayList((Object[])val.split(",")));
    }

    public void setValue(List<String> vals) {
        if (!this.isMultiple && vals.size() > 1) {
            throw new IllegalArgumentException("Not a multiple allowedValues, can only set one value");
        }
        for (PageElement option : this.getOptions()) {
            if (vals.contains(option.getText()) && !option.isSelected()) {
                option.click();
            }
            if (!this.isMultiple || vals.contains(option.getText()) || !option.isSelected()) continue;
            option.click();
        }
    }

    private List<PageElement> getOptions() {
        return this.selectInput.findAll(By.tagName((String)"option"));
    }

    private List<PageElement> getSelectedOptions() {
        return this.selectInput.findAll(By.cssSelector((String)"option[selected]"));
    }
}

