/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.integration.jira.element;

import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.binder.Init;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.integration.jira.element.JiraIssuePanel;
import com.atlassian.webdriver.integration.jira.element.JiraIssuesDialog;
import com.atlassian.webdriver.integration.jira.element.JiraTransitionAllowedValuesField;
import com.atlassian.webdriver.integration.jira.element.JiraTransitionAutoCompleteField;
import com.atlassian.webdriver.integration.jira.element.JiraTransitionTextField;
import com.atlassian.webdriver.integration.jira.element.JiraTransitionTextareaField;
import com.google.inject.Inject;
import org.openqa.selenium.By;

public class JiraTransitionForm {
    @Inject
    private PageBinder pageBinder;
    @Inject
    private PageElementFinder elementFinder;
    private PageElement pageRoot;
    private final PageElement container;
    private final JiraIssuesDialog parent;

    public JiraTransitionForm(PageElement container, JiraIssuesDialog parent) {
        this.container = container;
        this.parent = parent;
    }

    public JiraTransitionTextField getTextField(String name) {
        return this.getField(JiraTransitionTextField.class, By.cssSelector((String)("input[type=\"text\"][name=\"" + name + "\"]")));
    }

    public JiraTransitionTextareaField getTextareaField(String name) {
        return this.getField(JiraTransitionTextareaField.class, By.cssSelector((String)("textarea[name=\"" + name + "\"]")));
    }

    public JiraTransitionAllowedValuesField getAllowedValuesField(String name) {
        return this.getField(JiraTransitionAllowedValuesField.class, By.cssSelector((String)("select[name=\"" + name + "\"]")));
    }

    public JiraTransitionAutoCompleteField getAutoCompleteField(String name) {
        return this.getSelect2Field(JiraTransitionAutoCompleteField.class, By.cssSelector((String)("div[data-jira-type=\"" + name + "\"] > .select2-container > a")), By.cssSelector((String)".select2-drop-active"));
    }

    public TimedCondition isShowing() {
        return this.container.timed().isVisible();
    }

    public JiraIssuePanel submit() {
        PageElement submitButton = this.container.find(By.className((String)"jira-transition"));
        this.scrollTo(submitButton);
        submitButton.click();
        Poller.waitUntilFalse((TimedQuery)this.isShowing());
        return this.parent.getIssuePanel();
    }

    private <T> T getField(Class<T> type, By locator) {
        this.scrollTo(locator);
        return (T)this.pageBinder.bind(type, new Object[]{this.container.find(locator)});
    }

    private <T> T getSelect2Field(Class<T> type, By locator, By hiddenInputLocator) {
        this.scrollTo(locator);
        return (T)this.pageBinder.bind(type, new Object[]{this.container.find(locator), hiddenInputLocator, this.pageRoot});
    }

    @Init
    private void initRoot() {
        if (this.pageRoot == null) {
            this.pageRoot = this.elementFinder.find(By.tagName((String)"body"));
        }
    }

    private void scrollTo(By locator) {
        PageElement element = this.elementFinder.find(locator);
        this.scrollTo(element);
    }

    private void scrollTo(PageElement element) {
        if (!element.isVisible()) {
            this.container.javascript().execute("AJS.$('.detail-view').scrollTop(" + element.getLocation().getY() + ")", new Object[0]);
        }
    }
}

