/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.integration.jira.element;

import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.binder.Init;
import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.integration.jira.element.JiraIssuePanel;
import com.atlassian.webdriver.integration.jira.element.JiraTransitionForm;
import com.atlassian.webdriver.integration.jira.element.internal.OAuthConfirmPage;
import javax.inject.Inject;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;

public class JiraIssuesDialog {
    @Inject
    private WebDriver driver;
    @Inject
    private PageBinder pageBinder;
    @Inject
    private PageElementFinder elementFinder;
    private final By locator;
    private PageElement root;

    public JiraIssuesDialog(By locator) {
        this.locator = locator;
    }

    public JiraIssuesDialog completeOAuthDance(String jiraUsername, String jiraPassword) {
        this.waitUntilAuthenticationMessageShown();
        String currentWindowHandle = this.driver.getWindowHandle();
        this.root.find(By.className((String)"applink-authenticate"), TimeoutType.AJAX_ACTION).click();
        return (JiraIssuesDialog)((OAuthConfirmPage)this.pageBinder.bind(OAuthConfirmPage.class, new Object[]{this})).confirmHandlingWebLoginIfRequired(currentWindowHandle, jiraUsername, jiraPassword);
    }

    public TimedCondition isOpen() {
        return this.root.find(By.className((String)"dialog-components"), TimeoutType.DIALOG_LOAD).timed().isVisible();
    }

    public TimedCondition isShowing(String issueKey) {
        return this.getIssuePanel().isShowing(issueKey);
    }

    public void waitUntilDetailsShown() {
        Poller.waitUntilTrue((TimedQuery)this.root.find(By.className((String)"jira-issue-detailed"), TimeoutType.AJAX_ACTION).timed().isVisible());
    }

    public void waitUntilErrorsShown() {
        Poller.waitUntilTrue((TimedQuery)this.root.find(By.className((String)"jira-dialog-message"), TimeoutType.AJAX_ACTION).timed().isVisible());
    }

    public void waitUntilAuthenticationMessageShown() {
        Poller.waitUntilTrue((TimedQuery)this.root.find(By.className((String)"applink-authenticate"), TimeoutType.AJAX_ACTION).timed().isVisible());
    }

    public JiraIssuePanel getIssuePanel() {
        this.waitUntilDetailsShown();
        return (JiraIssuePanel)this.pageBinder.bind(JiraIssuePanel.class, new Object[]{this.root.find(By.className((String)"jira-issue-detailed")), this});
    }

    public JiraTransitionForm getTransitionForm() {
        return (JiraTransitionForm)this.pageBinder.bind(JiraTransitionForm.class, new Object[]{this.root.find(By.className((String)"jira-transition-form")), this});
    }

    public JiraIssuesDialog goToNextIssue() {
        String key = this.getIssuePanel().getIssueKey();
        this.driver.findElement(By.tagName((String)"body")).sendKeys(new CharSequence[]{"j"});
        Poller.waitUntilFalse((TimedQuery)this.isShowing(key));
        this.waitUntilDetailsShown();
        return this;
    }

    public JiraIssuesDialog goToPreviousIssue() {
        String key = this.getIssuePanel().getIssueKey();
        this.driver.findElement(By.tagName((String)"body")).sendKeys(new CharSequence[]{"k"});
        Poller.waitUntilFalse((TimedQuery)this.isShowing(key));
        this.waitUntilDetailsShown();
        return this;
    }

    public void close() {
        this.waitUntilOpen();
        this.root.find(By.className((String)"button-panel-cancel-link")).click();
        this.waitUntilClosed();
    }

    protected void waitUntilClosed() {
        Poller.waitUntilFalse((TimedQuery)this.isOpen());
    }

    @WaitUntil
    protected void waitUntilOpen() {
        this.initRoot();
        Poller.waitUntilTrue((TimedQuery)this.isOpen());
    }

    @Init
    private void initRoot() {
        if (this.root == null) {
            this.root = this.elementFinder.find(this.locator);
        }
    }
}

