/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.idp.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.immutables.value.Value;

public abstract class ScimListResponse<R> {
    public static final String SCHEMA = "urn:ietf:params:scim:api:messages:2.0:ListResponse";

    @Nullable
    @Value.Default
    public Set<String> getSchemas() {
        return Collections.singleton(SCHEMA);
    }

    @Nullable
    public abstract Integer getTotalResults();

    @Nullable
    public abstract Integer getStartIndex();

    @Nullable
    public abstract Integer getItemsPerPage();

    @Nullable
    @JsonProperty(value="Resources")
    public abstract List<R> getResources();

    @Value.Check
    protected void checkSchemas() {
        Optional.ofNullable(this.getSchemas()).ifPresent(schemas -> Preconditions.checkArgument((boolean)schemas.contains(SCHEMA), (Object)("Invalid schema ('" + Arrays.toString(schemas.toArray()) + "') provided. Required value is " + SCHEMA)));
    }
}

