/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.idp.model;

import com.atlassian.idp.model.AtlassianScimExtension;
import com.atlassian.idp.model.ScimEmail;
import com.atlassian.idp.model.ScimGroupForUser;
import com.atlassian.idp.model.ScimMeta;
import com.atlassian.idp.model.ScimName;
import com.atlassian.idp.model.ScimPhoneNumber;
import com.atlassian.idp.model.ScimUser;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Immutable
public final class ImmutableScimUser
extends ScimUser {
    @Nullable
    private final Set<String> schemas;
    @Nullable
    private final String id;
    @Nullable
    private final String userName;
    @Nullable
    private final Boolean active;
    @Nullable
    private final ScimName name;
    @Nullable
    private final String displayName;
    @Nullable
    private final String nickName;
    @Nullable
    private final String profileUrl;
    @Nullable
    private final String preferredLanguage;
    @Nullable
    private final String locale;
    @Nullable
    private final List<ScimPhoneNumber> phoneNumbers;
    @Nullable
    private final List<ScimEmail> emails;
    @Nullable
    private final AtlassianScimExtension atlassianScimExtension;
    @Nullable
    private final List<ScimGroupForUser> groups;
    @Nullable
    private final ScimMeta meta;
    @Nullable
    private final String title;
    @Nullable
    private final String timezone;

    private ImmutableScimUser(Builder builder) {
        this.id = builder.id;
        this.userName = builder.userName;
        this.active = builder.active;
        this.name = builder.name;
        this.displayName = builder.displayName;
        this.nickName = builder.nickName;
        this.profileUrl = builder.profileUrl;
        this.preferredLanguage = builder.preferredLanguage;
        this.locale = builder.locale;
        this.phoneNumbers = builder.phoneNumbers == null ? null : ImmutableScimUser.createUnmodifiableList(true, builder.phoneNumbers);
        this.emails = builder.emails == null ? null : ImmutableScimUser.createUnmodifiableList(true, builder.emails);
        this.atlassianScimExtension = builder.atlassianScimExtension;
        this.groups = builder.groups == null ? null : ImmutableScimUser.createUnmodifiableList(true, builder.groups);
        this.meta = builder.meta;
        this.title = builder.title;
        this.timezone = builder.timezone;
        this.schemas = builder.schemasIsSet() ? (builder.schemas == null ? null : ImmutableScimUser.createUnmodifiableSet(builder.schemas)) : (super.getSchemas() == null ? null : ImmutableScimUser.createUnmodifiableSet(ImmutableScimUser.createSafeList(super.getSchemas(), true, false)));
    }

    private ImmutableScimUser(@Nullable Set<String> schemas, @Nullable String id, @Nullable String userName, @Nullable Boolean active, @Nullable ScimName name, @Nullable String displayName, @Nullable String nickName, @Nullable String profileUrl, @Nullable String preferredLanguage, @Nullable String locale, @Nullable List<ScimPhoneNumber> phoneNumbers, @Nullable List<ScimEmail> emails, @Nullable AtlassianScimExtension atlassianScimExtension, @Nullable List<ScimGroupForUser> groups, @Nullable ScimMeta meta, @Nullable String title, @Nullable String timezone) {
        this.schemas = schemas;
        this.id = id;
        this.userName = userName;
        this.active = active;
        this.name = name;
        this.displayName = displayName;
        this.nickName = nickName;
        this.profileUrl = profileUrl;
        this.preferredLanguage = preferredLanguage;
        this.locale = locale;
        this.phoneNumbers = phoneNumbers;
        this.emails = emails;
        this.atlassianScimExtension = atlassianScimExtension;
        this.groups = groups;
        this.meta = meta;
        this.title = title;
        this.timezone = timezone;
    }

    @Override
    @JsonProperty
    @Nullable
    public Set<String> getSchemas() {
        return this.schemas;
    }

    @Override
    @JsonProperty
    @Nullable
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty
    @Nullable
    public String getUserName() {
        return this.userName;
    }

    @Override
    @JsonProperty
    @Nullable
    public Boolean isActive() {
        return this.active;
    }

    @Override
    @JsonProperty
    @Nullable
    public ScimName getName() {
        return this.name;
    }

    @Override
    @JsonProperty
    @Nullable
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @JsonProperty
    @Nullable
    public String getNickName() {
        return this.nickName;
    }

    @Override
    @JsonProperty
    @Nullable
    public String getProfileUrl() {
        return this.profileUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public String getPreferredLanguage() {
        return this.preferredLanguage;
    }

    @Override
    @JsonProperty
    @Nullable
    public String getLocale() {
        return this.locale;
    }

    @Override
    @JsonProperty
    @Nullable
    public List<ScimPhoneNumber> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    @Override
    @JsonProperty
    @Nullable
    public List<ScimEmail> getEmails() {
        return this.emails;
    }

    @Override
    @JsonProperty(value="urn:scim:schemas:extension:atlassian:1.0")
    @Nullable
    public AtlassianScimExtension getAtlassianScimExtension() {
        return this.atlassianScimExtension;
    }

    @Override
    @JsonProperty
    @Nullable
    public List<ScimGroupForUser> getGroups() {
        return this.groups;
    }

    @Override
    @JsonProperty
    @Nullable
    public ScimMeta getMeta() {
        return this.meta;
    }

    @Override
    @JsonProperty
    @Nullable
    public String getTitle() {
        return this.title;
    }

    @Override
    @JsonProperty
    @Nullable
    public String getTimezone() {
        return this.timezone;
    }

    public final ImmutableScimUser withSchemas(String ... elements) {
        if (elements == null) {
            return ImmutableScimUser.validate(new ImmutableScimUser(null, this.id, this.userName, this.active, this.name, this.displayName, this.nickName, this.profileUrl, this.preferredLanguage, this.locale, this.phoneNumbers, this.emails, this.atlassianScimExtension, this.groups, this.meta, this.title, this.timezone));
        }
        Set<String> newValue = Arrays.asList(elements) == null ? null : ImmutableScimUser.createUnmodifiableSet(ImmutableScimUser.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableScimUser.validate(new ImmutableScimUser(newValue, this.id, this.userName, this.active, this.name, this.displayName, this.nickName, this.profileUrl, this.preferredLanguage, this.locale, this.phoneNumbers, this.emails, this.atlassianScimExtension, this.groups, this.meta, this.title, this.timezone));
    }

    public final ImmutableScimUser withSchemas(@Nullable Iterable<String> elements) {
        if (this.schemas == elements) {
            return this;
        }
        Set<String> newValue = elements == null ? null : ImmutableScimUser.createUnmodifiableSet(ImmutableScimUser.createSafeList(elements, true, false));
        return ImmutableScimUser.validate(new ImmutableScimUser(newValue, this.id, this.userName, this.active, this.name, this.displayName, this.nickName, this.profileUrl, this.preferredLanguage, this.locale, this.phoneNumbers, this.emails, this.atlassianScimExtension, this.groups, this.meta, this.title, this.timezone));
    }

    public final ImmutableScimUser withId(@Nullable String value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return ImmutableScimUser.validate(new ImmutableScimUser(this.schemas, value, this.userName, this.active, this.name, this.displayName, this.nickName, this.profileUrl, this.preferredLanguage, this.locale, this.phoneNumbers, this.emails, this.atlassianScimExtension, this.groups, this.meta, this.title, this.timezone));
    }

    public final ImmutableScimUser withUserName(@Nullable String value) {
        if (Objects.equals(this.userName, value)) {
            return this;
        }
        return ImmutableScimUser.validate(new ImmutableScimUser(this.schemas, this.id, value, this.active, this.name, this.displayName, this.nickName, this.profileUrl, this.preferredLanguage, this.locale, this.phoneNumbers, this.emails, this.atlassianScimExtension, this.groups, this.meta, this.title, this.timezone));
    }

    public final ImmutableScimUser withActive(@Nullable Boolean value) {
        if (Objects.equals(this.active, value)) {
            return this;
        }
        return ImmutableScimUser.validate(new ImmutableScimUser(this.schemas, this.id, this.userName, value, this.name, this.displayName, this.nickName, this.profileUrl, this.preferredLanguage, this.locale, this.phoneNumbers, this.emails, this.atlassianScimExtension, this.groups, this.meta, this.title, this.timezone));
    }

    public final ImmutableScimUser withName(@Nullable ScimName value) {
        if (this.name == value) {
            return this;
        }
        return ImmutableScimUser.validate(new ImmutableScimUser(this.schemas, this.id, this.userName, this.active, value, this.displayName, this.nickName, this.profileUrl, this.preferredLanguage, this.locale, this.phoneNumbers, this.emails, this.atlassianScimExtension, this.groups, this.meta, this.title, this.timezone));
    }

    public final ImmutableScimUser withDisplayName(@Nullable String value) {
        if (Objects.equals(this.displayName, value)) {
            return this;
        }
        return ImmutableScimUser.validate(new ImmutableScimUser(this.schemas, this.id, this.userName, this.active, this.name, value, this.nickName, this.profileUrl, this.preferredLanguage, this.locale, this.phoneNumbers, this.emails, this.atlassianScimExtension, this.groups, this.meta, this.title, this.timezone));
    }

    public final ImmutableScimUser withNickName(@Nullable String value) {
        if (Objects.equals(this.nickName, value)) {
            return this;
        }
        return ImmutableScimUser.validate(new ImmutableScimUser(this.schemas, this.id, this.userName, this.active, this.name, this.displayName, value, this.profileUrl, this.preferredLanguage, this.locale, this.phoneNumbers, this.emails, this.atlassianScimExtension, this.groups, this.meta, this.title, this.timezone));
    }

    public final ImmutableScimUser withProfileUrl(@Nullable String value) {
        if (Objects.equals(this.profileUrl, value)) {
            return this;
        }
        return ImmutableScimUser.validate(new ImmutableScimUser(this.schemas, this.id, this.userName, this.active, this.name, this.displayName, this.nickName, value, this.preferredLanguage, this.locale, this.phoneNumbers, this.emails, this.atlassianScimExtension, this.groups, this.meta, this.title, this.timezone));
    }

    public final ImmutableScimUser withPreferredLanguage(@Nullable String value) {
        if (Objects.equals(this.preferredLanguage, value)) {
            return this;
        }
        return ImmutableScimUser.validate(new ImmutableScimUser(this.schemas, this.id, this.userName, this.active, this.name, this.displayName, this.nickName, this.profileUrl, value, this.locale, this.phoneNumbers, this.emails, this.atlassianScimExtension, this.groups, this.meta, this.title, this.timezone));
    }

    public final ImmutableScimUser withLocale(@Nullable String value) {
        if (Objects.equals(this.locale, value)) {
            return this;
        }
        return ImmutableScimUser.validate(new ImmutableScimUser(this.schemas, this.id, this.userName, this.active, this.name, this.displayName, this.nickName, this.profileUrl, this.preferredLanguage, value, this.phoneNumbers, this.emails, this.atlassianScimExtension, this.groups, this.meta, this.title, this.timezone));
    }

    public final ImmutableScimUser withPhoneNumbers(ScimPhoneNumber ... elements) {
        if (elements == null) {
            return ImmutableScimUser.validate(new ImmutableScimUser(this.schemas, this.id, this.userName, this.active, this.name, this.displayName, this.nickName, this.profileUrl, this.preferredLanguage, this.locale, null, this.emails, this.atlassianScimExtension, this.groups, this.meta, this.title, this.timezone));
        }
        List<ScimPhoneNumber> newValue = Arrays.asList(elements) == null ? null : ImmutableScimUser.createUnmodifiableList(false, ImmutableScimUser.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableScimUser.validate(new ImmutableScimUser(this.schemas, this.id, this.userName, this.active, this.name, this.displayName, this.nickName, this.profileUrl, this.preferredLanguage, this.locale, newValue, this.emails, this.atlassianScimExtension, this.groups, this.meta, this.title, this.timezone));
    }

    public final ImmutableScimUser withPhoneNumbers(@Nullable Iterable<? extends ScimPhoneNumber> elements) {
        if (this.phoneNumbers == elements) {
            return this;
        }
        List<ScimPhoneNumber> newValue = elements == null ? null : ImmutableScimUser.createUnmodifiableList(false, ImmutableScimUser.createSafeList(elements, true, false));
        return ImmutableScimUser.validate(new ImmutableScimUser(this.schemas, this.id, this.userName, this.active, this.name, this.displayName, this.nickName, this.profileUrl, this.preferredLanguage, this.locale, newValue, this.emails, this.atlassianScimExtension, this.groups, this.meta, this.title, this.timezone));
    }

    public final ImmutableScimUser withEmails(ScimEmail ... elements) {
        if (elements == null) {
            return ImmutableScimUser.validate(new ImmutableScimUser(this.schemas, this.id, this.userName, this.active, this.name, this.displayName, this.nickName, this.profileUrl, this.preferredLanguage, this.locale, this.phoneNumbers, null, this.atlassianScimExtension, this.groups, this.meta, this.title, this.timezone));
        }
        List<ScimEmail> newValue = Arrays.asList(elements) == null ? null : ImmutableScimUser.createUnmodifiableList(false, ImmutableScimUser.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableScimUser.validate(new ImmutableScimUser(this.schemas, this.id, this.userName, this.active, this.name, this.displayName, this.nickName, this.profileUrl, this.preferredLanguage, this.locale, this.phoneNumbers, newValue, this.atlassianScimExtension, this.groups, this.meta, this.title, this.timezone));
    }

    public final ImmutableScimUser withEmails(@Nullable Iterable<? extends ScimEmail> elements) {
        if (this.emails == elements) {
            return this;
        }
        List<ScimEmail> newValue = elements == null ? null : ImmutableScimUser.createUnmodifiableList(false, ImmutableScimUser.createSafeList(elements, true, false));
        return ImmutableScimUser.validate(new ImmutableScimUser(this.schemas, this.id, this.userName, this.active, this.name, this.displayName, this.nickName, this.profileUrl, this.preferredLanguage, this.locale, this.phoneNumbers, newValue, this.atlassianScimExtension, this.groups, this.meta, this.title, this.timezone));
    }

    public final ImmutableScimUser withAtlassianScimExtension(@Nullable AtlassianScimExtension value) {
        if (this.atlassianScimExtension == value) {
            return this;
        }
        return ImmutableScimUser.validate(new ImmutableScimUser(this.schemas, this.id, this.userName, this.active, this.name, this.displayName, this.nickName, this.profileUrl, this.preferredLanguage, this.locale, this.phoneNumbers, this.emails, value, this.groups, this.meta, this.title, this.timezone));
    }

    public final ImmutableScimUser withGroups(ScimGroupForUser ... elements) {
        if (elements == null) {
            return ImmutableScimUser.validate(new ImmutableScimUser(this.schemas, this.id, this.userName, this.active, this.name, this.displayName, this.nickName, this.profileUrl, this.preferredLanguage, this.locale, this.phoneNumbers, this.emails, this.atlassianScimExtension, null, this.meta, this.title, this.timezone));
        }
        List<ScimGroupForUser> newValue = Arrays.asList(elements) == null ? null : ImmutableScimUser.createUnmodifiableList(false, ImmutableScimUser.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableScimUser.validate(new ImmutableScimUser(this.schemas, this.id, this.userName, this.active, this.name, this.displayName, this.nickName, this.profileUrl, this.preferredLanguage, this.locale, this.phoneNumbers, this.emails, this.atlassianScimExtension, newValue, this.meta, this.title, this.timezone));
    }

    public final ImmutableScimUser withGroups(@Nullable Iterable<? extends ScimGroupForUser> elements) {
        if (this.groups == elements) {
            return this;
        }
        List<ScimGroupForUser> newValue = elements == null ? null : ImmutableScimUser.createUnmodifiableList(false, ImmutableScimUser.createSafeList(elements, true, false));
        return ImmutableScimUser.validate(new ImmutableScimUser(this.schemas, this.id, this.userName, this.active, this.name, this.displayName, this.nickName, this.profileUrl, this.preferredLanguage, this.locale, this.phoneNumbers, this.emails, this.atlassianScimExtension, newValue, this.meta, this.title, this.timezone));
    }

    public final ImmutableScimUser withMeta(@Nullable ScimMeta value) {
        if (this.meta == value) {
            return this;
        }
        return ImmutableScimUser.validate(new ImmutableScimUser(this.schemas, this.id, this.userName, this.active, this.name, this.displayName, this.nickName, this.profileUrl, this.preferredLanguage, this.locale, this.phoneNumbers, this.emails, this.atlassianScimExtension, this.groups, value, this.title, this.timezone));
    }

    public final ImmutableScimUser withTitle(@Nullable String value) {
        if (Objects.equals(this.title, value)) {
            return this;
        }
        return ImmutableScimUser.validate(new ImmutableScimUser(this.schemas, this.id, this.userName, this.active, this.name, this.displayName, this.nickName, this.profileUrl, this.preferredLanguage, this.locale, this.phoneNumbers, this.emails, this.atlassianScimExtension, this.groups, this.meta, value, this.timezone));
    }

    public final ImmutableScimUser withTimezone(@Nullable String value) {
        if (Objects.equals(this.timezone, value)) {
            return this;
        }
        return ImmutableScimUser.validate(new ImmutableScimUser(this.schemas, this.id, this.userName, this.active, this.name, this.displayName, this.nickName, this.profileUrl, this.preferredLanguage, this.locale, this.phoneNumbers, this.emails, this.atlassianScimExtension, this.groups, this.meta, this.title, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableScimUser && this.equalTo((ImmutableScimUser)another);
    }

    private boolean equalTo(ImmutableScimUser another) {
        return Objects.equals(this.schemas, another.schemas) && Objects.equals(this.id, another.id) && Objects.equals(this.userName, another.userName) && Objects.equals(this.active, another.active) && Objects.equals(this.name, another.name) && Objects.equals(this.displayName, another.displayName) && Objects.equals(this.nickName, another.nickName) && Objects.equals(this.profileUrl, another.profileUrl) && Objects.equals(this.preferredLanguage, another.preferredLanguage) && Objects.equals(this.locale, another.locale) && Objects.equals(this.phoneNumbers, another.phoneNumbers) && Objects.equals(this.emails, another.emails) && Objects.equals(this.atlassianScimExtension, another.atlassianScimExtension) && Objects.equals(this.groups, another.groups) && Objects.equals(this.meta, another.meta) && Objects.equals(this.title, another.title) && Objects.equals(this.timezone, another.timezone);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.schemas);
        h = h * 17 + Objects.hashCode(this.id);
        h = h * 17 + Objects.hashCode(this.userName);
        h = h * 17 + Objects.hashCode(this.active);
        h = h * 17 + Objects.hashCode(this.name);
        h = h * 17 + Objects.hashCode(this.displayName);
        h = h * 17 + Objects.hashCode(this.nickName);
        h = h * 17 + Objects.hashCode(this.profileUrl);
        h = h * 17 + Objects.hashCode(this.preferredLanguage);
        h = h * 17 + Objects.hashCode(this.locale);
        h = h * 17 + Objects.hashCode(this.phoneNumbers);
        h = h * 17 + Objects.hashCode(this.emails);
        h = h * 17 + Objects.hashCode(this.atlassianScimExtension);
        h = h * 17 + Objects.hashCode(this.groups);
        h = h * 17 + Objects.hashCode(this.meta);
        h = h * 17 + Objects.hashCode(this.title);
        h = h * 17 + Objects.hashCode(this.timezone);
        return h;
    }

    public String toString() {
        return "ScimUser{schemas=" + this.schemas + ", id=" + this.id + ", userName=" + this.userName + ", active=" + this.active + ", name=" + this.name + ", displayName=" + this.displayName + ", nickName=" + this.nickName + ", profileUrl=" + this.profileUrl + ", preferredLanguage=" + this.preferredLanguage + ", locale=" + this.locale + ", phoneNumbers=" + this.phoneNumbers + ", emails=" + this.emails + ", atlassianScimExtension=" + this.atlassianScimExtension + ", groups=" + this.groups + ", meta=" + this.meta + ", title=" + this.title + ", timezone=" + this.timezone + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableScimUser fromJson(Json json) {
        Builder builder = ImmutableScimUser.builder();
        if (json.schemasIsSet) {
            builder.withSchemas(json.schemas);
        }
        if (json.id != null) {
            builder.withId(json.id);
        }
        if (json.userName != null) {
            builder.withUserName(json.userName);
        }
        if (json.active != null) {
            builder.withActive(json.active);
        }
        if (json.name != null) {
            builder.withName(json.name);
        }
        if (json.displayName != null) {
            builder.withDisplayName(json.displayName);
        }
        if (json.nickName != null) {
            builder.withNickName(json.nickName);
        }
        if (json.profileUrl != null) {
            builder.withProfileUrl(json.profileUrl);
        }
        if (json.preferredLanguage != null) {
            builder.withPreferredLanguage(json.preferredLanguage);
        }
        if (json.locale != null) {
            builder.withLocale(json.locale);
        }
        if (json.phoneNumbers != null) {
            builder.addAllPhoneNumbers(json.phoneNumbers);
        }
        if (json.emails != null) {
            builder.addAllEmails(json.emails);
        }
        if (json.atlassianScimExtension != null) {
            builder.withAtlassianScimExtension(json.atlassianScimExtension);
        }
        if (json.groups != null) {
            builder.addAllGroups(json.groups);
        }
        if (json.meta != null) {
            builder.withMeta(json.meta);
        }
        if (json.title != null) {
            builder.withTitle(json.title);
        }
        if (json.timezone != null) {
            builder.withTimezone(json.timezone);
        }
        return builder.build();
    }

    private static ImmutableScimUser validate(ImmutableScimUser instance) {
        instance.checkSchemas();
        return instance;
    }

    public static ImmutableScimUser copyOf(ScimUser instance) {
        if (instance instanceof ImmutableScimUser) {
            return (ImmutableScimUser)instance;
        }
        return ImmutableScimUser.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size());
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_SCHEMAS = 1L;
        private long optBits;
        private List<String> schemas = null;
        @Nullable
        private String id;
        @Nullable
        private String userName;
        @Nullable
        private Boolean active;
        @Nullable
        private ScimName name;
        @Nullable
        private String displayName;
        @Nullable
        private String nickName;
        @Nullable
        private String profileUrl;
        @Nullable
        private String preferredLanguage;
        @Nullable
        private String locale;
        private List<ScimPhoneNumber> phoneNumbers = null;
        private List<ScimEmail> emails = null;
        @Nullable
        private AtlassianScimExtension atlassianScimExtension;
        private List<ScimGroupForUser> groups = null;
        @Nullable
        private ScimMeta meta;
        @Nullable
        private String title;
        @Nullable
        private String timezone;

        private Builder() {
        }

        public final Builder from(ScimUser instance) {
            String timezoneValue;
            String titleValue;
            ScimMeta metaValue;
            List<ScimGroupForUser> groupsValue;
            AtlassianScimExtension atlassianScimExtensionValue;
            List<ScimEmail> emailsValue;
            List<ScimPhoneNumber> phoneNumbersValue;
            String localeValue;
            String preferredLanguageValue;
            String profileUrlValue;
            String nickNameValue;
            String displayNameValue;
            ScimName nameValue;
            Boolean activeValue;
            String userNameValue;
            String idValue;
            Objects.requireNonNull(instance, "instance");
            Set<String> schemasValue = instance.getSchemas();
            if (schemasValue != null) {
                this.addAllSchemas(schemasValue);
            }
            if ((idValue = instance.getId()) != null) {
                this.withId(idValue);
            }
            if ((userNameValue = instance.getUserName()) != null) {
                this.withUserName(userNameValue);
            }
            if ((activeValue = instance.isActive()) != null) {
                this.withActive(activeValue);
            }
            if ((nameValue = instance.getName()) != null) {
                this.withName(nameValue);
            }
            if ((displayNameValue = instance.getDisplayName()) != null) {
                this.withDisplayName(displayNameValue);
            }
            if ((nickNameValue = instance.getNickName()) != null) {
                this.withNickName(nickNameValue);
            }
            if ((profileUrlValue = instance.getProfileUrl()) != null) {
                this.withProfileUrl(profileUrlValue);
            }
            if ((preferredLanguageValue = instance.getPreferredLanguage()) != null) {
                this.withPreferredLanguage(preferredLanguageValue);
            }
            if ((localeValue = instance.getLocale()) != null) {
                this.withLocale(localeValue);
            }
            if ((phoneNumbersValue = instance.getPhoneNumbers()) != null) {
                this.addAllPhoneNumbers(phoneNumbersValue);
            }
            if ((emailsValue = instance.getEmails()) != null) {
                this.addAllEmails(emailsValue);
            }
            if ((atlassianScimExtensionValue = instance.getAtlassianScimExtension()) != null) {
                this.withAtlassianScimExtension(atlassianScimExtensionValue);
            }
            if ((groupsValue = instance.getGroups()) != null) {
                this.addAllGroups(groupsValue);
            }
            if ((metaValue = instance.getMeta()) != null) {
                this.withMeta(metaValue);
            }
            if ((titleValue = instance.getTitle()) != null) {
                this.withTitle(titleValue);
            }
            if ((timezoneValue = instance.getTimezone()) != null) {
                this.withTimezone(timezoneValue);
            }
            return this;
        }

        public final Builder addSchemas(String element) {
            if (this.schemas == null) {
                this.schemas = new ArrayList<String>();
            }
            this.schemas.add(Objects.requireNonNull(element, "schemas element"));
            this.optBits |= 1L;
            return this;
        }

        public final Builder addSchemas(String ... elements) {
            if (this.schemas == null) {
                this.schemas = new ArrayList<String>();
            }
            for (String element : elements) {
                this.schemas.add(Objects.requireNonNull(element, "schemas element"));
            }
            this.optBits |= 1L;
            return this;
        }

        public final Builder withSchemas(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.schemas = null;
                this.optBits |= 1L;
                return this;
            }
            this.schemas = new ArrayList<String>();
            return this.addAllSchemas(elements);
        }

        public final Builder addAllSchemas(Iterable<String> elements) {
            Objects.requireNonNull(elements, "schemas element");
            if (this.schemas == null) {
                this.schemas = new ArrayList<String>();
            }
            for (String element : elements) {
                this.schemas.add(Objects.requireNonNull(element, "schemas element"));
            }
            this.optBits |= 1L;
            return this;
        }

        public final Builder withId(@Nullable String id) {
            this.id = id;
            return this;
        }

        public final Builder withUserName(@Nullable String userName) {
            this.userName = userName;
            return this;
        }

        public final Builder withActive(@Nullable Boolean active) {
            this.active = active;
            return this;
        }

        public final Builder withName(@Nullable ScimName name) {
            this.name = name;
            return this;
        }

        public final Builder withDisplayName(@Nullable String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final Builder withNickName(@Nullable String nickName) {
            this.nickName = nickName;
            return this;
        }

        public final Builder withProfileUrl(@Nullable String profileUrl) {
            this.profileUrl = profileUrl;
            return this;
        }

        public final Builder withPreferredLanguage(@Nullable String preferredLanguage) {
            this.preferredLanguage = preferredLanguage;
            return this;
        }

        public final Builder withLocale(@Nullable String locale) {
            this.locale = locale;
            return this;
        }

        public final Builder addPhoneNumbers(ScimPhoneNumber element) {
            if (this.phoneNumbers == null) {
                this.phoneNumbers = new ArrayList<ScimPhoneNumber>();
            }
            this.phoneNumbers.add(Objects.requireNonNull(element, "phoneNumbers element"));
            return this;
        }

        public final Builder addPhoneNumbers(ScimPhoneNumber ... elements) {
            if (this.phoneNumbers == null) {
                this.phoneNumbers = new ArrayList<ScimPhoneNumber>();
            }
            for (ScimPhoneNumber element : elements) {
                this.phoneNumbers.add(Objects.requireNonNull(element, "phoneNumbers element"));
            }
            return this;
        }

        public final Builder withPhoneNumbers(@Nullable Iterable<? extends ScimPhoneNumber> elements) {
            if (elements == null) {
                this.phoneNumbers = null;
                return this;
            }
            this.phoneNumbers = new ArrayList<ScimPhoneNumber>();
            return this.addAllPhoneNumbers(elements);
        }

        public final Builder addAllPhoneNumbers(Iterable<? extends ScimPhoneNumber> elements) {
            Objects.requireNonNull(elements, "phoneNumbers element");
            if (this.phoneNumbers == null) {
                this.phoneNumbers = new ArrayList<ScimPhoneNumber>();
            }
            for (ScimPhoneNumber scimPhoneNumber : elements) {
                this.phoneNumbers.add(Objects.requireNonNull(scimPhoneNumber, "phoneNumbers element"));
            }
            return this;
        }

        public final Builder addEmails(ScimEmail element) {
            if (this.emails == null) {
                this.emails = new ArrayList<ScimEmail>();
            }
            this.emails.add(Objects.requireNonNull(element, "emails element"));
            return this;
        }

        public final Builder addEmails(ScimEmail ... elements) {
            if (this.emails == null) {
                this.emails = new ArrayList<ScimEmail>();
            }
            for (ScimEmail element : elements) {
                this.emails.add(Objects.requireNonNull(element, "emails element"));
            }
            return this;
        }

        public final Builder withEmails(@Nullable Iterable<? extends ScimEmail> elements) {
            if (elements == null) {
                this.emails = null;
                return this;
            }
            this.emails = new ArrayList<ScimEmail>();
            return this.addAllEmails(elements);
        }

        public final Builder addAllEmails(Iterable<? extends ScimEmail> elements) {
            Objects.requireNonNull(elements, "emails element");
            if (this.emails == null) {
                this.emails = new ArrayList<ScimEmail>();
            }
            for (ScimEmail scimEmail : elements) {
                this.emails.add(Objects.requireNonNull(scimEmail, "emails element"));
            }
            return this;
        }

        public final Builder withAtlassianScimExtension(@Nullable AtlassianScimExtension atlassianScimExtension) {
            this.atlassianScimExtension = atlassianScimExtension;
            return this;
        }

        public final Builder addGroups(ScimGroupForUser element) {
            if (this.groups == null) {
                this.groups = new ArrayList<ScimGroupForUser>();
            }
            this.groups.add(Objects.requireNonNull(element, "groups element"));
            return this;
        }

        public final Builder addGroups(ScimGroupForUser ... elements) {
            if (this.groups == null) {
                this.groups = new ArrayList<ScimGroupForUser>();
            }
            for (ScimGroupForUser element : elements) {
                this.groups.add(Objects.requireNonNull(element, "groups element"));
            }
            return this;
        }

        public final Builder withGroups(@Nullable Iterable<? extends ScimGroupForUser> elements) {
            if (elements == null) {
                this.groups = null;
                return this;
            }
            this.groups = new ArrayList<ScimGroupForUser>();
            return this.addAllGroups(elements);
        }

        public final Builder addAllGroups(Iterable<? extends ScimGroupForUser> elements) {
            Objects.requireNonNull(elements, "groups element");
            if (this.groups == null) {
                this.groups = new ArrayList<ScimGroupForUser>();
            }
            for (ScimGroupForUser scimGroupForUser : elements) {
                this.groups.add(Objects.requireNonNull(scimGroupForUser, "groups element"));
            }
            return this;
        }

        public final Builder withMeta(@Nullable ScimMeta meta) {
            this.meta = meta;
            return this;
        }

        public final Builder withTitle(@Nullable String title) {
            this.title = title;
            return this;
        }

        public final Builder withTimezone(@Nullable String timezone) {
            this.timezone = timezone;
            return this;
        }

        public ImmutableScimUser build() {
            return ImmutableScimUser.validate(new ImmutableScimUser(this));
        }

        private boolean schemasIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends ScimUser {
        Set<String> schemas = null;
        boolean schemasIsSet;
        @Nullable
        String id;
        @Nullable
        String userName;
        @Nullable
        Boolean active;
        @Nullable
        ScimName name;
        @Nullable
        String displayName;
        @Nullable
        String nickName;
        @Nullable
        String profileUrl;
        @Nullable
        String preferredLanguage;
        @Nullable
        String locale;
        List<ScimPhoneNumber> phoneNumbers = null;
        List<ScimEmail> emails = null;
        @Nullable
        AtlassianScimExtension atlassianScimExtension;
        List<ScimGroupForUser> groups = null;
        @Nullable
        ScimMeta meta;
        @Nullable
        String title;
        @Nullable
        String timezone;

        Json() {
        }

        @JsonProperty
        public void setSchemas(@Nullable Set<String> schemas) {
            this.schemas = schemas;
            this.schemasIsSet = true;
        }

        @JsonProperty
        public void setId(@Nullable String id) {
            this.id = id;
        }

        @JsonProperty
        public void setUserName(@Nullable String userName) {
            this.userName = userName;
        }

        @JsonProperty
        public void setActive(@Nullable Boolean active) {
            this.active = active;
        }

        @JsonProperty
        public void setName(@Nullable ScimName name) {
            this.name = name;
        }

        @JsonProperty
        public void setDisplayName(@Nullable String displayName) {
            this.displayName = displayName;
        }

        @JsonProperty
        public void setNickName(@Nullable String nickName) {
            this.nickName = nickName;
        }

        @JsonProperty
        public void setProfileUrl(@Nullable String profileUrl) {
            this.profileUrl = profileUrl;
        }

        @JsonProperty
        public void setPreferredLanguage(@Nullable String preferredLanguage) {
            this.preferredLanguage = preferredLanguage;
        }

        @JsonProperty
        public void setLocale(@Nullable String locale) {
            this.locale = locale;
        }

        @JsonProperty
        public void setPhoneNumbers(@Nullable List<ScimPhoneNumber> phoneNumbers) {
            this.phoneNumbers = phoneNumbers;
        }

        @JsonProperty
        public void setEmails(@Nullable List<ScimEmail> emails) {
            this.emails = emails;
        }

        @JsonProperty(value="urn:scim:schemas:extension:atlassian:1.0")
        public void setAtlassianScimExtension(@Nullable AtlassianScimExtension atlassianScimExtension) {
            this.atlassianScimExtension = atlassianScimExtension;
        }

        @JsonProperty
        public void setGroups(@Nullable List<ScimGroupForUser> groups) {
            this.groups = groups;
        }

        @JsonProperty
        public void setMeta(@Nullable ScimMeta meta) {
            this.meta = meta;
        }

        @JsonProperty
        public void setTitle(@Nullable String title) {
            this.title = title;
        }

        @JsonProperty
        public void setTimezone(@Nullable String timezone) {
            this.timezone = timezone;
        }

        @Override
        public Set<String> getSchemas() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUserName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean isActive() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ScimName getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDisplayName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getNickName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getProfileUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPreferredLanguage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getLocale() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ScimPhoneNumber> getPhoneNumbers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ScimEmail> getEmails() {
            throw new UnsupportedOperationException();
        }

        @Override
        public AtlassianScimExtension getAtlassianScimExtension() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ScimGroupForUser> getGroups() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ScimMeta getMeta() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTitle() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTimezone() {
            throw new UnsupportedOperationException();
        }
    }
}

