/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.idp.model;

import com.atlassian.idp.model.ScimOperation;
import com.atlassian.idp.model.ScimPatchOp;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Immutable
public final class ImmutableScimPatchOp
extends ScimPatchOp {
    private final Set<String> schemas;
    private final List<ScimOperation> operations;

    private ImmutableScimPatchOp(Builder builder) {
        this.operations = ImmutableScimPatchOp.createUnmodifiableList(true, builder.operations);
        this.schemas = builder.schemasIsSet() ? ImmutableScimPatchOp.createUnmodifiableSet(builder.schemas) : ImmutableScimPatchOp.createUnmodifiableSet(ImmutableScimPatchOp.createSafeList(super.getSchemas(), true, false));
    }

    private ImmutableScimPatchOp(Set<String> schemas, List<ScimOperation> operations) {
        this.schemas = schemas;
        this.operations = operations;
    }

    @Override
    @JsonProperty
    public Set<String> getSchemas() {
        return this.schemas;
    }

    @Override
    @JsonProperty(value="Operations")
    public List<ScimOperation> getOperations() {
        return this.operations;
    }

    public final ImmutableScimPatchOp withSchemas(String ... elements) {
        Set<String> newValue = ImmutableScimPatchOp.createUnmodifiableSet(ImmutableScimPatchOp.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableScimPatchOp(newValue, this.operations);
    }

    public final ImmutableScimPatchOp withSchemas(Iterable<String> elements) {
        if (this.schemas == elements) {
            return this;
        }
        Set<String> newValue = ImmutableScimPatchOp.createUnmodifiableSet(ImmutableScimPatchOp.createSafeList(elements, true, false));
        return new ImmutableScimPatchOp(newValue, this.operations);
    }

    public final ImmutableScimPatchOp withOperations(ScimOperation ... elements) {
        List<ScimOperation> newValue = ImmutableScimPatchOp.createUnmodifiableList(false, ImmutableScimPatchOp.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableScimPatchOp(this.schemas, newValue);
    }

    public final ImmutableScimPatchOp withOperations(Iterable<? extends ScimOperation> elements) {
        if (this.operations == elements) {
            return this;
        }
        List<ScimOperation> newValue = ImmutableScimPatchOp.createUnmodifiableList(false, ImmutableScimPatchOp.createSafeList(elements, true, false));
        return new ImmutableScimPatchOp(this.schemas, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableScimPatchOp && this.equalTo((ImmutableScimPatchOp)another);
    }

    private boolean equalTo(ImmutableScimPatchOp another) {
        return this.schemas.equals(another.schemas) && this.operations.equals(another.operations);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.schemas.hashCode();
        h = h * 17 + this.operations.hashCode();
        return h;
    }

    public String toString() {
        return "ScimPatchOp{schemas=" + this.schemas + ", operations=" + this.operations + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableScimPatchOp fromJson(Json json) {
        Builder builder = ImmutableScimPatchOp.builder();
        if (json.schemasIsSet) {
            builder.withSchemas(json.schemas);
        }
        if (json.operations != null) {
            builder.addAllOperations(json.operations);
        }
        return builder.build();
    }

    public static ImmutableScimPatchOp copyOf(ScimPatchOp instance) {
        if (instance instanceof ImmutableScimPatchOp) {
            return (ImmutableScimPatchOp)instance;
        }
        return ImmutableScimPatchOp.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size());
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_SCHEMAS = 1L;
        private long optBits;
        private List<String> schemas = new ArrayList<String>();
        private List<ScimOperation> operations = new ArrayList<ScimOperation>();

        private Builder() {
        }

        public final Builder from(ScimPatchOp instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllSchemas(instance.getSchemas());
            this.addAllOperations(instance.getOperations());
            return this;
        }

        public final Builder addSchemas(String element) {
            this.schemas.add(Objects.requireNonNull(element, "schemas element"));
            this.optBits |= 1L;
            return this;
        }

        public final Builder addSchemas(String ... elements) {
            for (String element : elements) {
                this.schemas.add(Objects.requireNonNull(element, "schemas element"));
            }
            this.optBits |= 1L;
            return this;
        }

        public final Builder withSchemas(Iterable<String> elements) {
            this.schemas.clear();
            return this.addAllSchemas(elements);
        }

        public final Builder addAllSchemas(Iterable<String> elements) {
            for (String element : elements) {
                this.schemas.add(Objects.requireNonNull(element, "schemas element"));
            }
            this.optBits |= 1L;
            return this;
        }

        public final Builder addOperations(ScimOperation element) {
            this.operations.add(Objects.requireNonNull(element, "operations element"));
            return this;
        }

        public final Builder addOperations(ScimOperation ... elements) {
            for (ScimOperation element : elements) {
                this.operations.add(Objects.requireNonNull(element, "operations element"));
            }
            return this;
        }

        public final Builder withOperations(Iterable<? extends ScimOperation> elements) {
            this.operations.clear();
            return this.addAllOperations(elements);
        }

        public final Builder addAllOperations(Iterable<? extends ScimOperation> elements) {
            for (ScimOperation scimOperation : elements) {
                this.operations.add(Objects.requireNonNull(scimOperation, "operations element"));
            }
            return this;
        }

        public ImmutableScimPatchOp build() {
            return new ImmutableScimPatchOp(this);
        }

        private boolean schemasIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends ScimPatchOp {
        Set<String> schemas = Collections.emptySet();
        boolean schemasIsSet;
        List<ScimOperation> operations = Collections.emptyList();

        Json() {
        }

        @JsonProperty
        public void setSchemas(Set<String> schemas) {
            this.schemas = schemas;
            this.schemasIsSet = true;
        }

        @JsonProperty(value="Operations")
        public void setOperations(List<ScimOperation> operations) {
            this.operations = operations;
        }

        @Override
        public Set<String> getSchemas() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ScimOperation> getOperations() {
            throw new UnsupportedOperationException();
        }
    }
}

