/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.idp.model;

import com.atlassian.idp.model.ScimMeta;
import com.atlassian.idp.util.OffsetDateTimeCodecs;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Immutable
public final class ImmutableScimMeta
extends ScimMeta {
    @Nullable
    private final String resourceType;
    @Nullable
    private final OffsetDateTime lastModified;
    @Nullable
    private final OffsetDateTime created;

    private ImmutableScimMeta(@Nullable String resourceType, @Nullable OffsetDateTime lastModified, @Nullable OffsetDateTime created) {
        this.resourceType = resourceType;
        this.lastModified = lastModified;
        this.created = created;
    }

    @Override
    @JsonProperty
    @Nullable
    public String getResourceType() {
        return this.resourceType;
    }

    @Override
    @JsonProperty
    @JsonSerialize(using=OffsetDateTimeCodecs.Serializer.class)
    @JsonDeserialize(using=OffsetDateTimeCodecs.Deserializer.class)
    @Nullable
    public OffsetDateTime getLastModified() {
        return this.lastModified;
    }

    @Override
    @JsonProperty
    @JsonSerialize(using=OffsetDateTimeCodecs.Serializer.class)
    @JsonDeserialize(using=OffsetDateTimeCodecs.Deserializer.class)
    @Nullable
    public OffsetDateTime getCreated() {
        return this.created;
    }

    public final ImmutableScimMeta withResourceType(@Nullable String value) {
        if (Objects.equals(this.resourceType, value)) {
            return this;
        }
        return new ImmutableScimMeta(value, this.lastModified, this.created);
    }

    public final ImmutableScimMeta withLastModified(@Nullable OffsetDateTime value) {
        if (this.lastModified == value) {
            return this;
        }
        return new ImmutableScimMeta(this.resourceType, value, this.created);
    }

    public final ImmutableScimMeta withCreated(@Nullable OffsetDateTime value) {
        if (this.created == value) {
            return this;
        }
        return new ImmutableScimMeta(this.resourceType, this.lastModified, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableScimMeta && this.equalTo((ImmutableScimMeta)another);
    }

    private boolean equalTo(ImmutableScimMeta another) {
        return Objects.equals(this.resourceType, another.resourceType) && Objects.equals(this.lastModified, another.lastModified) && Objects.equals(this.created, another.created);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.resourceType);
        h = h * 17 + Objects.hashCode(this.lastModified);
        h = h * 17 + Objects.hashCode(this.created);
        return h;
    }

    public String toString() {
        return "ScimMeta{resourceType=" + this.resourceType + ", lastModified=" + this.lastModified + ", created=" + this.created + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableScimMeta fromJson(Json json) {
        Builder builder = ImmutableScimMeta.builder();
        if (json.resourceType != null) {
            builder.withResourceType(json.resourceType);
        }
        if (json.lastModified != null) {
            builder.withLastModified(json.lastModified);
        }
        if (json.created != null) {
            builder.withCreated(json.created);
        }
        return builder.build();
    }

    public static ImmutableScimMeta of(@Nullable String resourceType, @Nullable OffsetDateTime lastModified, @Nullable OffsetDateTime created) {
        return new ImmutableScimMeta(resourceType, lastModified, created);
    }

    public static ImmutableScimMeta copyOf(ScimMeta instance) {
        if (instance instanceof ImmutableScimMeta) {
            return (ImmutableScimMeta)instance;
        }
        return ImmutableScimMeta.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String resourceType;
        @Nullable
        private OffsetDateTime lastModified;
        @Nullable
        private OffsetDateTime created;

        private Builder() {
        }

        public final Builder from(ScimMeta instance) {
            OffsetDateTime createdValue;
            OffsetDateTime lastModifiedValue;
            Objects.requireNonNull(instance, "instance");
            String resourceTypeValue = instance.getResourceType();
            if (resourceTypeValue != null) {
                this.withResourceType(resourceTypeValue);
            }
            if ((lastModifiedValue = instance.getLastModified()) != null) {
                this.withLastModified(lastModifiedValue);
            }
            if ((createdValue = instance.getCreated()) != null) {
                this.withCreated(createdValue);
            }
            return this;
        }

        public final Builder withResourceType(@Nullable String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final Builder withLastModified(@Nullable OffsetDateTime lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final Builder withCreated(@Nullable OffsetDateTime created) {
            this.created = created;
            return this;
        }

        public ImmutableScimMeta build() {
            return new ImmutableScimMeta(this.resourceType, this.lastModified, this.created);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends ScimMeta {
        @Nullable
        String resourceType;
        @Nullable
        OffsetDateTime lastModified;
        @Nullable
        OffsetDateTime created;

        Json() {
        }

        @JsonProperty
        public void setResourceType(@Nullable String resourceType) {
            this.resourceType = resourceType;
        }

        @JsonProperty
        @JsonSerialize(using=OffsetDateTimeCodecs.Serializer.class)
        @JsonDeserialize(using=OffsetDateTimeCodecs.Deserializer.class)
        public void setLastModified(@Nullable OffsetDateTime lastModified) {
            this.lastModified = lastModified;
        }

        @JsonProperty
        @JsonSerialize(using=OffsetDateTimeCodecs.Serializer.class)
        @JsonDeserialize(using=OffsetDateTimeCodecs.Deserializer.class)
        public void setCreated(@Nullable OffsetDateTime created) {
            this.created = created;
        }

        @Override
        public String getResourceType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public OffsetDateTime getLastModified() {
            throw new UnsupportedOperationException();
        }

        @Override
        public OffsetDateTime getCreated() {
            throw new UnsupportedOperationException();
        }
    }
}

