/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.idp.model;

import com.atlassian.idp.model.AtlassianScimExtension;
import com.atlassian.idp.model.ScimGroup;
import com.atlassian.idp.model.ScimGroupMember;
import com.atlassian.idp.model.ScimMeta;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Immutable
public final class ImmutableScimGroup
extends ScimGroup {
    @Nullable
    private final Set<String> schemas;
    @Nullable
    private final String id;
    @Nullable
    private final String displayName;
    @Nullable
    private final List<ScimGroupMember> members;
    @Nullable
    private final ScimMeta meta;
    @Nullable
    private final AtlassianScimExtension atlassianScimExtension;

    private ImmutableScimGroup(@Nullable Iterable<String> schemas, @Nullable String id, @Nullable String displayName, @Nullable Iterable<? extends ScimGroupMember> members, @Nullable ScimMeta meta, @Nullable AtlassianScimExtension atlassianScimExtension) {
        this.schemas = schemas == null ? null : ImmutableScimGroup.createUnmodifiableSet(ImmutableScimGroup.createSafeList(schemas, true, false));
        this.id = id;
        this.displayName = displayName;
        this.members = members == null ? null : ImmutableScimGroup.createUnmodifiableList(false, ImmutableScimGroup.createSafeList(members, true, false));
        this.meta = meta;
        this.atlassianScimExtension = atlassianScimExtension;
    }

    private ImmutableScimGroup(Builder builder) {
        this.id = builder.id;
        this.displayName = builder.displayName;
        this.members = builder.members == null ? null : ImmutableScimGroup.createUnmodifiableList(true, builder.members);
        this.meta = builder.meta;
        this.atlassianScimExtension = builder.atlassianScimExtension;
        this.schemas = builder.schemasIsSet() ? (builder.schemas == null ? null : ImmutableScimGroup.createUnmodifiableSet(builder.schemas)) : (super.getSchemas() == null ? null : ImmutableScimGroup.createUnmodifiableSet(ImmutableScimGroup.createSafeList(super.getSchemas(), true, false)));
    }

    private ImmutableScimGroup(ImmutableScimGroup original, @Nullable Set<String> schemas, @Nullable String id, @Nullable String displayName, @Nullable List<ScimGroupMember> members, @Nullable ScimMeta meta, @Nullable AtlassianScimExtension atlassianScimExtension) {
        this.schemas = schemas;
        this.id = id;
        this.displayName = displayName;
        this.members = members;
        this.meta = meta;
        this.atlassianScimExtension = atlassianScimExtension;
    }

    @Override
    @JsonProperty
    @Nullable
    public Set<String> getSchemas() {
        return this.schemas;
    }

    @Override
    @JsonProperty
    @Nullable
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty
    @Nullable
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @JsonProperty
    @Nullable
    public List<ScimGroupMember> getMembers() {
        return this.members;
    }

    @Override
    @JsonProperty
    @Nullable
    public ScimMeta getMeta() {
        return this.meta;
    }

    @Override
    @JsonProperty(value="urn:scim:schemas:extension:atlassian:1.0")
    @Nullable
    public AtlassianScimExtension getAtlassianScimExtension() {
        return this.atlassianScimExtension;
    }

    public final ImmutableScimGroup withSchemas(String ... elements) {
        if (elements == null) {
            return ImmutableScimGroup.validate(new ImmutableScimGroup(this, null, this.id, this.displayName, this.members, this.meta, this.atlassianScimExtension));
        }
        Set<String> newValue = Arrays.asList(elements) == null ? null : ImmutableScimGroup.createUnmodifiableSet(ImmutableScimGroup.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableScimGroup.validate(new ImmutableScimGroup(this, newValue, this.id, this.displayName, this.members, this.meta, this.atlassianScimExtension));
    }

    public final ImmutableScimGroup withSchemas(@Nullable Iterable<String> elements) {
        if (this.schemas == elements) {
            return this;
        }
        Set<String> newValue = elements == null ? null : ImmutableScimGroup.createUnmodifiableSet(ImmutableScimGroup.createSafeList(elements, true, false));
        return ImmutableScimGroup.validate(new ImmutableScimGroup(this, newValue, this.id, this.displayName, this.members, this.meta, this.atlassianScimExtension));
    }

    public final ImmutableScimGroup withId(@Nullable String value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return ImmutableScimGroup.validate(new ImmutableScimGroup(this, this.schemas, value, this.displayName, this.members, this.meta, this.atlassianScimExtension));
    }

    public final ImmutableScimGroup withDisplayName(@Nullable String value) {
        if (Objects.equals(this.displayName, value)) {
            return this;
        }
        return ImmutableScimGroup.validate(new ImmutableScimGroup(this, this.schemas, this.id, value, this.members, this.meta, this.atlassianScimExtension));
    }

    public final ImmutableScimGroup withMembers(ScimGroupMember ... elements) {
        if (elements == null) {
            return ImmutableScimGroup.validate(new ImmutableScimGroup(this, this.schemas, this.id, this.displayName, null, this.meta, this.atlassianScimExtension));
        }
        List<ScimGroupMember> newValue = Arrays.asList(elements) == null ? null : ImmutableScimGroup.createUnmodifiableList(false, ImmutableScimGroup.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableScimGroup.validate(new ImmutableScimGroup(this, this.schemas, this.id, this.displayName, newValue, this.meta, this.atlassianScimExtension));
    }

    public final ImmutableScimGroup withMembers(@Nullable Iterable<? extends ScimGroupMember> elements) {
        if (this.members == elements) {
            return this;
        }
        List<ScimGroupMember> newValue = elements == null ? null : ImmutableScimGroup.createUnmodifiableList(false, ImmutableScimGroup.createSafeList(elements, true, false));
        return ImmutableScimGroup.validate(new ImmutableScimGroup(this, this.schemas, this.id, this.displayName, newValue, this.meta, this.atlassianScimExtension));
    }

    public final ImmutableScimGroup withMeta(@Nullable ScimMeta value) {
        if (this.meta == value) {
            return this;
        }
        return ImmutableScimGroup.validate(new ImmutableScimGroup(this, this.schemas, this.id, this.displayName, this.members, value, this.atlassianScimExtension));
    }

    public final ImmutableScimGroup withAtlassianScimExtension(@Nullable AtlassianScimExtension value) {
        if (this.atlassianScimExtension == value) {
            return this;
        }
        return ImmutableScimGroup.validate(new ImmutableScimGroup(this, this.schemas, this.id, this.displayName, this.members, this.meta, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableScimGroup && this.equalTo((ImmutableScimGroup)another);
    }

    private boolean equalTo(ImmutableScimGroup another) {
        return Objects.equals(this.schemas, another.schemas) && Objects.equals(this.id, another.id) && Objects.equals(this.displayName, another.displayName) && Objects.equals(this.members, another.members) && Objects.equals(this.meta, another.meta) && Objects.equals(this.atlassianScimExtension, another.atlassianScimExtension);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.schemas);
        h = h * 17 + Objects.hashCode(this.id);
        h = h * 17 + Objects.hashCode(this.displayName);
        h = h * 17 + Objects.hashCode(this.members);
        h = h * 17 + Objects.hashCode(this.meta);
        h = h * 17 + Objects.hashCode(this.atlassianScimExtension);
        return h;
    }

    public String toString() {
        return "ScimGroup{schemas=" + this.schemas + ", id=" + this.id + ", displayName=" + this.displayName + ", members=" + this.members + ", meta=" + this.meta + ", atlassianScimExtension=" + this.atlassianScimExtension + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableScimGroup fromJson(Json json) {
        Builder builder = ImmutableScimGroup.builder();
        if (json.schemasIsSet) {
            builder.withSchemas(json.schemas);
        }
        if (json.id != null) {
            builder.withId(json.id);
        }
        if (json.displayName != null) {
            builder.withDisplayName(json.displayName);
        }
        if (json.members != null) {
            builder.addAllMembers(json.members);
        }
        if (json.meta != null) {
            builder.withMeta(json.meta);
        }
        if (json.atlassianScimExtension != null) {
            builder.withAtlassianScimExtension(json.atlassianScimExtension);
        }
        return builder.build();
    }

    public static ImmutableScimGroup of(@Nullable Set<String> schemas, @Nullable String id, @Nullable String displayName, @Nullable List<ScimGroupMember> members, @Nullable ScimMeta meta, @Nullable AtlassianScimExtension atlassianScimExtension) {
        return ImmutableScimGroup.of(schemas, id, displayName, members, meta, atlassianScimExtension);
    }

    public static ImmutableScimGroup of(@Nullable Iterable<String> schemas, @Nullable String id, @Nullable String displayName, @Nullable Iterable<? extends ScimGroupMember> members, @Nullable ScimMeta meta, @Nullable AtlassianScimExtension atlassianScimExtension) {
        return ImmutableScimGroup.validate(new ImmutableScimGroup(schemas, id, displayName, members, meta, atlassianScimExtension));
    }

    private static ImmutableScimGroup validate(ImmutableScimGroup instance) {
        instance.checkSchemas();
        return instance;
    }

    public static ImmutableScimGroup copyOf(ScimGroup instance) {
        if (instance instanceof ImmutableScimGroup) {
            return (ImmutableScimGroup)instance;
        }
        return ImmutableScimGroup.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size());
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_SCHEMAS = 1L;
        private long optBits;
        private List<String> schemas = null;
        @Nullable
        private String id;
        @Nullable
        private String displayName;
        private List<ScimGroupMember> members = null;
        @Nullable
        private ScimMeta meta;
        @Nullable
        private AtlassianScimExtension atlassianScimExtension;

        private Builder() {
        }

        public final Builder from(ScimGroup instance) {
            AtlassianScimExtension atlassianScimExtensionValue;
            ScimMeta metaValue;
            List<ScimGroupMember> membersValue;
            String displayNameValue;
            String idValue;
            Objects.requireNonNull(instance, "instance");
            Set<String> schemasValue = instance.getSchemas();
            if (schemasValue != null) {
                this.addAllSchemas(schemasValue);
            }
            if ((idValue = instance.getId()) != null) {
                this.withId(idValue);
            }
            if ((displayNameValue = instance.getDisplayName()) != null) {
                this.withDisplayName(displayNameValue);
            }
            if ((membersValue = instance.getMembers()) != null) {
                this.addAllMembers(membersValue);
            }
            if ((metaValue = instance.getMeta()) != null) {
                this.withMeta(metaValue);
            }
            if ((atlassianScimExtensionValue = instance.getAtlassianScimExtension()) != null) {
                this.withAtlassianScimExtension(atlassianScimExtensionValue);
            }
            return this;
        }

        public final Builder addSchemas(String element) {
            if (this.schemas == null) {
                this.schemas = new ArrayList<String>();
            }
            this.schemas.add(Objects.requireNonNull(element, "schemas element"));
            this.optBits |= 1L;
            return this;
        }

        public final Builder addSchemas(String ... elements) {
            if (this.schemas == null) {
                this.schemas = new ArrayList<String>();
            }
            for (String element : elements) {
                this.schemas.add(Objects.requireNonNull(element, "schemas element"));
            }
            this.optBits |= 1L;
            return this;
        }

        public final Builder withSchemas(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.schemas = null;
                this.optBits |= 1L;
                return this;
            }
            this.schemas = new ArrayList<String>();
            return this.addAllSchemas(elements);
        }

        public final Builder addAllSchemas(Iterable<String> elements) {
            Objects.requireNonNull(elements, "schemas element");
            if (this.schemas == null) {
                this.schemas = new ArrayList<String>();
            }
            for (String element : elements) {
                this.schemas.add(Objects.requireNonNull(element, "schemas element"));
            }
            this.optBits |= 1L;
            return this;
        }

        public final Builder withId(@Nullable String id) {
            this.id = id;
            return this;
        }

        public final Builder withDisplayName(@Nullable String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final Builder addMembers(ScimGroupMember element) {
            if (this.members == null) {
                this.members = new ArrayList<ScimGroupMember>();
            }
            this.members.add(Objects.requireNonNull(element, "members element"));
            return this;
        }

        public final Builder addMembers(ScimGroupMember ... elements) {
            if (this.members == null) {
                this.members = new ArrayList<ScimGroupMember>();
            }
            for (ScimGroupMember element : elements) {
                this.members.add(Objects.requireNonNull(element, "members element"));
            }
            return this;
        }

        public final Builder withMembers(@Nullable Iterable<? extends ScimGroupMember> elements) {
            if (elements == null) {
                this.members = null;
                return this;
            }
            this.members = new ArrayList<ScimGroupMember>();
            return this.addAllMembers(elements);
        }

        public final Builder addAllMembers(Iterable<? extends ScimGroupMember> elements) {
            Objects.requireNonNull(elements, "members element");
            if (this.members == null) {
                this.members = new ArrayList<ScimGroupMember>();
            }
            for (ScimGroupMember scimGroupMember : elements) {
                this.members.add(Objects.requireNonNull(scimGroupMember, "members element"));
            }
            return this;
        }

        public final Builder withMeta(@Nullable ScimMeta meta) {
            this.meta = meta;
            return this;
        }

        public final Builder withAtlassianScimExtension(@Nullable AtlassianScimExtension atlassianScimExtension) {
            this.atlassianScimExtension = atlassianScimExtension;
            return this;
        }

        public ImmutableScimGroup build() {
            return ImmutableScimGroup.validate(new ImmutableScimGroup(this));
        }

        private boolean schemasIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends ScimGroup {
        Set<String> schemas = null;
        boolean schemasIsSet;
        @Nullable
        String id;
        @Nullable
        String displayName;
        List<ScimGroupMember> members = null;
        @Nullable
        ScimMeta meta;
        @Nullable
        AtlassianScimExtension atlassianScimExtension;

        Json() {
        }

        @JsonProperty
        public void setSchemas(@Nullable Set<String> schemas) {
            this.schemas = schemas;
            this.schemasIsSet = true;
        }

        @JsonProperty
        public void setId(@Nullable String id) {
            this.id = id;
        }

        @JsonProperty
        public void setDisplayName(@Nullable String displayName) {
            this.displayName = displayName;
        }

        @JsonProperty
        public void setMembers(@Nullable List<ScimGroupMember> members) {
            this.members = members;
        }

        @JsonProperty
        public void setMeta(@Nullable ScimMeta meta) {
            this.meta = meta;
        }

        @JsonProperty(value="urn:scim:schemas:extension:atlassian:1.0")
        public void setAtlassianScimExtension(@Nullable AtlassianScimExtension atlassianScimExtension) {
            this.atlassianScimExtension = atlassianScimExtension;
        }

        @Override
        public Set<String> getSchemas() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDisplayName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ScimGroupMember> getMembers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ScimMeta getMeta() {
            throw new UnsupportedOperationException();
        }

        @Override
        public AtlassianScimExtension getAtlassianScimExtension() {
            throw new UnsupportedOperationException();
        }
    }
}

