/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.idp.util;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

public class OffsetDateTimeCodecs {

    public static class Deserializer
    extends JsonDeserializer<OffsetDateTime> {
        public OffsetDateTime deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            try {
                return OffsetDateTime.parse(p.getValueAsString());
            }
            catch (DateTimeParseException e) {
                throw new JsonParseException("Error deserializing ZonedDateTime", p.getCurrentLocation(), (Throwable)e);
            }
        }
    }

    public static class Serializer
    extends JsonSerializer<OffsetDateTime> {
        public void serialize(OffsetDateTime value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            try {
                gen.writeString(DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(value));
            }
            catch (DateTimeException e) {
                throw new JsonGenerationException("Error serializing ZonedDateTime", (Throwable)e);
            }
        }
    }
}

