/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.idp.model;

import com.atlassian.idp.model.AtlassianScimExtension;
import com.atlassian.idp.model.ImmutableScimUser;
import com.atlassian.idp.model.ScimEmail;
import com.atlassian.idp.model.ScimGroupForUser;
import com.atlassian.idp.model.ScimMeta;
import com.atlassian.idp.model.ScimName;
import com.atlassian.idp.model.ScimPhoneNumber;
import com.atlassian.idp.model.annotation.ScimValue;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.immutables.value.Value;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonSerialize(as=ImmutableScimUser.class)
@JsonDeserialize(as=ImmutableScimUser.class)
@ScimValue
@Value.Immutable
public abstract class ScimUser {
    public static final String SCHEMA = "urn:ietf:params:scim:schemas:core:2.0:User";

    @Nullable
    @Value.Default
    public Set<String> getSchemas() {
        return ImmutableSet.of((Object)SCHEMA, (Object)"urn:scim:schemas:extension:atlassian:1.0");
    }

    @Nullable
    public abstract String getId();

    @Nullable
    public abstract String getUserName();

    @Nullable
    public abstract Boolean isActive();

    @Nullable
    public abstract ScimName getName();

    @Nullable
    public abstract String getDisplayName();

    @Nullable
    public abstract String getNickName();

    @Nullable
    public abstract String getProfileUrl();

    @Nullable
    public abstract String getPreferredLanguage();

    @Nullable
    public abstract String getLocale();

    @Nullable
    public abstract List<ScimPhoneNumber> getPhoneNumbers();

    @Nullable
    public abstract List<ScimEmail> getEmails();

    @Nullable
    @JsonProperty(value="urn:scim:schemas:extension:atlassian:1.0")
    public abstract AtlassianScimExtension getAtlassianScimExtension();

    @Nullable
    public abstract List<ScimGroupForUser> getGroups();

    @Nullable
    public abstract ScimMeta getMeta();

    @Nullable
    public abstract String getTitle();

    @Nullable
    public abstract String getTimezone();

    @Value.Check
    protected void checkSchemas() {
        Optional.ofNullable(this.getSchemas()).ifPresent(schemas -> Preconditions.checkArgument((boolean)schemas.contains(SCHEMA), (Object)("Invalid schema ('" + Arrays.toString(schemas.toArray()) + "') provided. Required value is " + SCHEMA)));
    }
}

