/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.idp.model;

import com.atlassian.idp.model.ImmutableScimSearchRequest;
import com.atlassian.idp.model.ScimSortOrder;
import com.atlassian.idp.model.annotation.ScimValue;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.immutables.value.Value;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonSerialize(as=ImmutableScimSearchRequest.class)
@JsonDeserialize(as=ImmutableScimSearchRequest.class)
@ScimValue
@Value.Immutable
public abstract class ScimSearchRequest {
    public static final String SCHEMA = "urn:ietf:params:scim:api:messages:2.0:SearchRequest";

    @Value.Default
    public List<String> getSchemas() {
        return Collections.singletonList(SCHEMA);
    }

    @Nullable
    public abstract List<String> getAttributes();

    @Nullable
    public abstract List<String> getExcludedAttributes();

    @Nullable
    public abstract String getFilter();

    @Nullable
    public abstract String getSortBy();

    @Nullable
    public abstract ScimSortOrder getSortOrder();

    @Nullable
    public abstract Integer getStartIndex();

    @Value.Check
    protected ScimSearchRequest normalizeStartIndex() {
        Optional<Integer> maybeStartIndex = Optional.ofNullable(this.getStartIndex());
        return maybeStartIndex.map(startIndex -> startIndex < 1 ? ImmutableScimSearchRequest.builder().from(this).withStartIndex(1).build() : this).orElse(this);
    }

    @Nullable
    public abstract Integer getCount();

    @Value.Check
    protected ScimSearchRequest normalizeCount() {
        Optional<Integer> maybeCount = Optional.ofNullable(this.getCount());
        return maybeCount.map(count -> count < 0 ? ImmutableScimSearchRequest.builder().from(this).withCount(0).build() : this).orElse(this);
    }

    @Value.Derived
    public boolean shouldHideResources() {
        Optional<Integer> maybeCount = Optional.ofNullable(this.getCount());
        return maybeCount.map(count -> count == 0).orElse(Boolean.FALSE);
    }
}

