/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.idp.model;

import com.atlassian.idp.model.ImmutableScimOperation;
import com.atlassian.idp.model.ScimAttribute;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringEscapeUtils;

public class ScimOperations {
    public static ImmutableScimOperation newAddOperation() {
        return ImmutableScimOperation.builder().withOp("add").build();
    }

    public static ImmutableScimOperation newRemoveOperation() {
        return ImmutableScimOperation.builder().withOp("remove").build();
    }

    public static ImmutableScimOperation newReplaceOperation() {
        return ImmutableScimOperation.builder().withOp("replace").build();
    }

    public static JsonNode attributesAsValue(List<ScimAttribute> attributes) {
        ObjectMapper objectMapper = new ObjectMapper();
        return (JsonNode)objectMapper.convertValue(attributes, ArrayNode.class);
    }

    public static JsonNode membersAsValue(Set<String> aaIds) {
        JsonNodeFactory jsonNodeFactory = new JsonNodeFactory(true);
        ArrayNode value = jsonNodeFactory.arrayNode();
        aaIds.stream().map(m -> jsonNodeFactory.objectNode().put("value", m)).forEach(arg_0 -> ((ArrayNode)value).add(arg_0));
        return value;
    }

    public static String attributeKeyEqFilter(String key) {
        return "urn:scim:schemas:extension:atlassian:1.0.attributes[key eq \"" + StringEscapeUtils.escapeEcmaScript((String)key) + "\"]";
    }

    public static String memberEqFilter(String key) {
        return "members[value eq \"" + StringEscapeUtils.escapeEcmaScript((String)key) + "\"]";
    }
}

