/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.idp.model;

import com.atlassian.idp.model.ScimPhoneNumber;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Immutable
public final class ImmutableScimPhoneNumber
extends ScimPhoneNumber {
    private final String value;
    @Nullable
    private final String type;
    @Nullable
    private final Boolean primary;

    private ImmutableScimPhoneNumber(String value, @Nullable String type, @Nullable Boolean primary) {
        this.value = Objects.requireNonNull(value, "value");
        this.type = type;
        this.primary = primary;
    }

    private ImmutableScimPhoneNumber(Builder builder) {
        this.value = builder.value;
        this.type = builder.type;
        this.primary = builder.primaryIsSet() ? builder.primary : super.isPrimary();
    }

    private ImmutableScimPhoneNumber(ImmutableScimPhoneNumber original, String value, @Nullable String type, @Nullable Boolean primary) {
        this.value = value;
        this.type = type;
        this.primary = primary;
    }

    @Override
    @JsonProperty
    public String getValue() {
        return this.value;
    }

    @Override
    @JsonProperty
    @Nullable
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    @Nullable
    public Boolean isPrimary() {
        return this.primary;
    }

    public final ImmutableScimPhoneNumber withValue(String value) {
        if (this.value.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "value");
        return new ImmutableScimPhoneNumber(this, newValue, this.type, this.primary);
    }

    public final ImmutableScimPhoneNumber withType(@Nullable String value) {
        if (Objects.equals(this.type, value)) {
            return this;
        }
        return new ImmutableScimPhoneNumber(this, this.value, value, this.primary);
    }

    public final ImmutableScimPhoneNumber withPrimary(@Nullable Boolean value) {
        if (Objects.equals(this.primary, value)) {
            return this;
        }
        return new ImmutableScimPhoneNumber(this, this.value, this.type, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableScimPhoneNumber && this.equalTo((ImmutableScimPhoneNumber)another);
    }

    private boolean equalTo(ImmutableScimPhoneNumber another) {
        return this.value.equals(another.value) && Objects.equals(this.type, another.type) && Objects.equals(this.primary, another.primary);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.value.hashCode();
        h = h * 17 + Objects.hashCode(this.type);
        h = h * 17 + Objects.hashCode(this.primary);
        return h;
    }

    public String toString() {
        return "ScimPhoneNumber{value=" + this.value + ", type=" + this.type + ", primary=" + this.primary + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableScimPhoneNumber fromJson(Json json) {
        Builder builder = ImmutableScimPhoneNumber.builder();
        if (json.value != null) {
            builder.withValue(json.value);
        }
        if (json.type != null) {
            builder.withType(json.type);
        }
        if (json.primaryIsSet) {
            builder.withPrimary(json.primary);
        }
        return builder.build();
    }

    public static ImmutableScimPhoneNumber of(String value, @Nullable String type, @Nullable Boolean primary) {
        return new ImmutableScimPhoneNumber(value, type, primary);
    }

    public static ImmutableScimPhoneNumber copyOf(ScimPhoneNumber instance) {
        if (instance instanceof ImmutableScimPhoneNumber) {
            return (ImmutableScimPhoneNumber)instance;
        }
        return ImmutableScimPhoneNumber.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VALUE = 1L;
        private static final long OPT_BIT_PRIMARY = 1L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private String value;
        @Nullable
        private String type;
        @Nullable
        private Boolean primary;

        private Builder() {
        }

        public final Builder from(ScimPhoneNumber instance) {
            Boolean primaryValue;
            Objects.requireNonNull(instance, "instance");
            this.withValue(instance.getValue());
            String typeValue = instance.getType();
            if (typeValue != null) {
                this.withType(typeValue);
            }
            if ((primaryValue = instance.isPrimary()) != null) {
                this.withPrimary(primaryValue);
            }
            return this;
        }

        public final Builder withValue(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder withType(@Nullable String type) {
            this.type = type;
            return this;
        }

        public final Builder withPrimary(@Nullable Boolean primary) {
            this.primary = primary;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableScimPhoneNumber build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableScimPhoneNumber(this);
        }

        private boolean primaryIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build ScimPhoneNumber, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends ScimPhoneNumber {
        @Nullable
        String value;
        @Nullable
        String type;
        @Nullable
        Boolean primary;
        boolean primaryIsSet;

        Json() {
        }

        @JsonProperty
        public void setValue(String value) {
            this.value = value;
        }

        @JsonProperty
        public void setType(@Nullable String type) {
            this.type = type;
        }

        @JsonProperty
        public void setPrimary(@Nullable Boolean primary) {
            this.primary = primary;
            this.primaryIsSet = true;
        }

        @Override
        public String getValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean isPrimary() {
            throw new UnsupportedOperationException();
        }
    }
}

