/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.idp.model;

import com.atlassian.idp.model.AtlassianScimExtension;
import com.atlassian.idp.model.ScimAttribute;
import com.atlassian.idp.model.ScimGroupManagementAccess;
import com.atlassian.idp.model.ScimGroupPrivilege;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Immutable
public final class ImmutableAtlassianScimExtension
extends AtlassianScimExtension {
    @Nullable
    private final String legacyUnicornUsername;
    @Nullable
    private final String description;
    @Nullable
    private final List<ScimAttribute> attributes;
    @Nullable
    private final String previousId;
    @Nullable
    private final ScimGroupManagementAccess managementAccess;
    @Nullable
    private final ScimGroupPrivilege privilege;
    @Nullable
    private final String location;
    @Nullable
    private final String companyName;
    @Nullable
    private final String department;
    @Nullable
    private final String position;
    @Nullable
    private final List<String> validatedEmails;
    @Nullable
    private final String googleId;
    @Nullable
    private final String samlId;
    @Nullable
    private final String latestIpAddress;
    @Nullable
    private final Boolean profileActive;
    @Nullable
    private final Boolean userbaseActive;

    private ImmutableAtlassianScimExtension(@Nullable String legacyUnicornUsername, @Nullable String description, @Nullable Iterable<? extends ScimAttribute> attributes, @Nullable String previousId, @Nullable ScimGroupManagementAccess managementAccess, @Nullable ScimGroupPrivilege privilege, @Nullable String location, @Nullable String companyName, @Nullable String department, @Nullable String position, @Nullable Iterable<String> validatedEmails, @Nullable String googleId, @Nullable String samlId, @Nullable String latestIpAddress, @Nullable Boolean profileActive, @Nullable Boolean userbaseActive) {
        this.legacyUnicornUsername = legacyUnicornUsername;
        this.description = description;
        this.attributes = attributes == null ? null : ImmutableAtlassianScimExtension.createUnmodifiableList(false, ImmutableAtlassianScimExtension.createSafeList(attributes, true, false));
        this.previousId = previousId;
        this.managementAccess = managementAccess;
        this.privilege = privilege;
        this.location = location;
        this.companyName = companyName;
        this.department = department;
        this.position = position;
        this.validatedEmails = validatedEmails == null ? null : ImmutableAtlassianScimExtension.createUnmodifiableList(false, ImmutableAtlassianScimExtension.createSafeList(validatedEmails, true, false));
        this.googleId = googleId;
        this.samlId = samlId;
        this.latestIpAddress = latestIpAddress;
        this.profileActive = profileActive;
        this.userbaseActive = userbaseActive;
    }

    private ImmutableAtlassianScimExtension(ImmutableAtlassianScimExtension original, @Nullable String legacyUnicornUsername, @Nullable String description, @Nullable List<ScimAttribute> attributes, @Nullable String previousId, @Nullable ScimGroupManagementAccess managementAccess, @Nullable ScimGroupPrivilege privilege, @Nullable String location, @Nullable String companyName, @Nullable String department, @Nullable String position, @Nullable List<String> validatedEmails, @Nullable String googleId, @Nullable String samlId, @Nullable String latestIpAddress, @Nullable Boolean profileActive, @Nullable Boolean userbaseActive) {
        this.legacyUnicornUsername = legacyUnicornUsername;
        this.description = description;
        this.attributes = attributes;
        this.previousId = previousId;
        this.managementAccess = managementAccess;
        this.privilege = privilege;
        this.location = location;
        this.companyName = companyName;
        this.department = department;
        this.position = position;
        this.validatedEmails = validatedEmails;
        this.googleId = googleId;
        this.samlId = samlId;
        this.latestIpAddress = latestIpAddress;
        this.profileActive = profileActive;
        this.userbaseActive = userbaseActive;
    }

    @Override
    @JsonProperty
    @Nullable
    public String getLegacyUnicornUsername() {
        return this.legacyUnicornUsername;
    }

    @Override
    @JsonProperty
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    @JsonProperty
    @Nullable
    public List<ScimAttribute> getAttributes() {
        return this.attributes;
    }

    @Override
    @JsonProperty
    @Nullable
    public String getPreviousId() {
        return this.previousId;
    }

    @Override
    @JsonProperty
    @Nullable
    public ScimGroupManagementAccess getManagementAccess() {
        return this.managementAccess;
    }

    @Override
    @JsonProperty
    @Nullable
    public ScimGroupPrivilege getPrivilege() {
        return this.privilege;
    }

    @Override
    @JsonProperty
    @Nullable
    public String getLocation() {
        return this.location;
    }

    @Override
    @JsonProperty
    @Nullable
    public String getCompanyName() {
        return this.companyName;
    }

    @Override
    @JsonProperty
    @Nullable
    public String getDepartment() {
        return this.department;
    }

    @Override
    @JsonProperty
    @Nullable
    public String getPosition() {
        return this.position;
    }

    @Override
    @JsonProperty
    @Nullable
    public List<String> getValidatedEmails() {
        return this.validatedEmails;
    }

    @Override
    @JsonProperty
    @Nullable
    public String getGoogleId() {
        return this.googleId;
    }

    @Override
    @JsonProperty
    @Nullable
    public String getSamlId() {
        return this.samlId;
    }

    @Override
    @JsonProperty
    @Nullable
    public String getLatestIpAddress() {
        return this.latestIpAddress;
    }

    @Override
    @JsonProperty
    @Nullable
    public Boolean isProfileActive() {
        return this.profileActive;
    }

    @Override
    @JsonProperty
    @Nullable
    public Boolean isUserbaseActive() {
        return this.userbaseActive;
    }

    public final ImmutableAtlassianScimExtension withLegacyUnicornUsername(@Nullable String value) {
        if (Objects.equals(this.legacyUnicornUsername, value)) {
            return this;
        }
        return new ImmutableAtlassianScimExtension(this, value, this.description, this.attributes, this.previousId, this.managementAccess, this.privilege, this.location, this.companyName, this.department, this.position, this.validatedEmails, this.googleId, this.samlId, this.latestIpAddress, this.profileActive, this.userbaseActive);
    }

    public final ImmutableAtlassianScimExtension withDescription(@Nullable String value) {
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableAtlassianScimExtension(this, this.legacyUnicornUsername, value, this.attributes, this.previousId, this.managementAccess, this.privilege, this.location, this.companyName, this.department, this.position, this.validatedEmails, this.googleId, this.samlId, this.latestIpAddress, this.profileActive, this.userbaseActive);
    }

    public final ImmutableAtlassianScimExtension withAttributes(ScimAttribute ... elements) {
        if (elements == null) {
            return new ImmutableAtlassianScimExtension(this, this.legacyUnicornUsername, this.description, null, this.previousId, this.managementAccess, this.privilege, this.location, this.companyName, this.department, this.position, this.validatedEmails, this.googleId, this.samlId, this.latestIpAddress, this.profileActive, this.userbaseActive);
        }
        List<ScimAttribute> newValue = Arrays.asList(elements) == null ? null : ImmutableAtlassianScimExtension.createUnmodifiableList(false, ImmutableAtlassianScimExtension.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableAtlassianScimExtension(this, this.legacyUnicornUsername, this.description, newValue, this.previousId, this.managementAccess, this.privilege, this.location, this.companyName, this.department, this.position, this.validatedEmails, this.googleId, this.samlId, this.latestIpAddress, this.profileActive, this.userbaseActive);
    }

    public final ImmutableAtlassianScimExtension withAttributes(@Nullable Iterable<? extends ScimAttribute> elements) {
        if (this.attributes == elements) {
            return this;
        }
        List<ScimAttribute> newValue = elements == null ? null : ImmutableAtlassianScimExtension.createUnmodifiableList(false, ImmutableAtlassianScimExtension.createSafeList(elements, true, false));
        return new ImmutableAtlassianScimExtension(this, this.legacyUnicornUsername, this.description, newValue, this.previousId, this.managementAccess, this.privilege, this.location, this.companyName, this.department, this.position, this.validatedEmails, this.googleId, this.samlId, this.latestIpAddress, this.profileActive, this.userbaseActive);
    }

    public final ImmutableAtlassianScimExtension withPreviousId(@Nullable String value) {
        if (Objects.equals(this.previousId, value)) {
            return this;
        }
        return new ImmutableAtlassianScimExtension(this, this.legacyUnicornUsername, this.description, this.attributes, value, this.managementAccess, this.privilege, this.location, this.companyName, this.department, this.position, this.validatedEmails, this.googleId, this.samlId, this.latestIpAddress, this.profileActive, this.userbaseActive);
    }

    public final ImmutableAtlassianScimExtension withManagementAccess(@Nullable ScimGroupManagementAccess value) {
        if (this.managementAccess == value) {
            return this;
        }
        return new ImmutableAtlassianScimExtension(this, this.legacyUnicornUsername, this.description, this.attributes, this.previousId, value, this.privilege, this.location, this.companyName, this.department, this.position, this.validatedEmails, this.googleId, this.samlId, this.latestIpAddress, this.profileActive, this.userbaseActive);
    }

    public final ImmutableAtlassianScimExtension withPrivilege(@Nullable ScimGroupPrivilege value) {
        if (this.privilege == value) {
            return this;
        }
        return new ImmutableAtlassianScimExtension(this, this.legacyUnicornUsername, this.description, this.attributes, this.previousId, this.managementAccess, value, this.location, this.companyName, this.department, this.position, this.validatedEmails, this.googleId, this.samlId, this.latestIpAddress, this.profileActive, this.userbaseActive);
    }

    public final ImmutableAtlassianScimExtension withLocation(@Nullable String value) {
        if (Objects.equals(this.location, value)) {
            return this;
        }
        return new ImmutableAtlassianScimExtension(this, this.legacyUnicornUsername, this.description, this.attributes, this.previousId, this.managementAccess, this.privilege, value, this.companyName, this.department, this.position, this.validatedEmails, this.googleId, this.samlId, this.latestIpAddress, this.profileActive, this.userbaseActive);
    }

    public final ImmutableAtlassianScimExtension withCompanyName(@Nullable String value) {
        if (Objects.equals(this.companyName, value)) {
            return this;
        }
        return new ImmutableAtlassianScimExtension(this, this.legacyUnicornUsername, this.description, this.attributes, this.previousId, this.managementAccess, this.privilege, this.location, value, this.department, this.position, this.validatedEmails, this.googleId, this.samlId, this.latestIpAddress, this.profileActive, this.userbaseActive);
    }

    public final ImmutableAtlassianScimExtension withDepartment(@Nullable String value) {
        if (Objects.equals(this.department, value)) {
            return this;
        }
        return new ImmutableAtlassianScimExtension(this, this.legacyUnicornUsername, this.description, this.attributes, this.previousId, this.managementAccess, this.privilege, this.location, this.companyName, value, this.position, this.validatedEmails, this.googleId, this.samlId, this.latestIpAddress, this.profileActive, this.userbaseActive);
    }

    public final ImmutableAtlassianScimExtension withPosition(@Nullable String value) {
        if (Objects.equals(this.position, value)) {
            return this;
        }
        return new ImmutableAtlassianScimExtension(this, this.legacyUnicornUsername, this.description, this.attributes, this.previousId, this.managementAccess, this.privilege, this.location, this.companyName, this.department, value, this.validatedEmails, this.googleId, this.samlId, this.latestIpAddress, this.profileActive, this.userbaseActive);
    }

    public final ImmutableAtlassianScimExtension withValidatedEmails(String ... elements) {
        if (elements == null) {
            return new ImmutableAtlassianScimExtension(this, this.legacyUnicornUsername, this.description, this.attributes, this.previousId, this.managementAccess, this.privilege, this.location, this.companyName, this.department, this.position, null, this.googleId, this.samlId, this.latestIpAddress, this.profileActive, this.userbaseActive);
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableAtlassianScimExtension.createUnmodifiableList(false, ImmutableAtlassianScimExtension.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableAtlassianScimExtension(this, this.legacyUnicornUsername, this.description, this.attributes, this.previousId, this.managementAccess, this.privilege, this.location, this.companyName, this.department, this.position, newValue, this.googleId, this.samlId, this.latestIpAddress, this.profileActive, this.userbaseActive);
    }

    public final ImmutableAtlassianScimExtension withValidatedEmails(@Nullable Iterable<String> elements) {
        if (this.validatedEmails == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableAtlassianScimExtension.createUnmodifiableList(false, ImmutableAtlassianScimExtension.createSafeList(elements, true, false));
        return new ImmutableAtlassianScimExtension(this, this.legacyUnicornUsername, this.description, this.attributes, this.previousId, this.managementAccess, this.privilege, this.location, this.companyName, this.department, this.position, newValue, this.googleId, this.samlId, this.latestIpAddress, this.profileActive, this.userbaseActive);
    }

    public final ImmutableAtlassianScimExtension withGoogleId(@Nullable String value) {
        if (Objects.equals(this.googleId, value)) {
            return this;
        }
        return new ImmutableAtlassianScimExtension(this, this.legacyUnicornUsername, this.description, this.attributes, this.previousId, this.managementAccess, this.privilege, this.location, this.companyName, this.department, this.position, this.validatedEmails, value, this.samlId, this.latestIpAddress, this.profileActive, this.userbaseActive);
    }

    public final ImmutableAtlassianScimExtension withSamlId(@Nullable String value) {
        if (Objects.equals(this.samlId, value)) {
            return this;
        }
        return new ImmutableAtlassianScimExtension(this, this.legacyUnicornUsername, this.description, this.attributes, this.previousId, this.managementAccess, this.privilege, this.location, this.companyName, this.department, this.position, this.validatedEmails, this.googleId, value, this.latestIpAddress, this.profileActive, this.userbaseActive);
    }

    public final ImmutableAtlassianScimExtension withLatestIpAddress(@Nullable String value) {
        if (Objects.equals(this.latestIpAddress, value)) {
            return this;
        }
        return new ImmutableAtlassianScimExtension(this, this.legacyUnicornUsername, this.description, this.attributes, this.previousId, this.managementAccess, this.privilege, this.location, this.companyName, this.department, this.position, this.validatedEmails, this.googleId, this.samlId, value, this.profileActive, this.userbaseActive);
    }

    public final ImmutableAtlassianScimExtension withProfileActive(@Nullable Boolean value) {
        if (Objects.equals(this.profileActive, value)) {
            return this;
        }
        return new ImmutableAtlassianScimExtension(this, this.legacyUnicornUsername, this.description, this.attributes, this.previousId, this.managementAccess, this.privilege, this.location, this.companyName, this.department, this.position, this.validatedEmails, this.googleId, this.samlId, this.latestIpAddress, value, this.userbaseActive);
    }

    public final ImmutableAtlassianScimExtension withUserbaseActive(@Nullable Boolean value) {
        if (Objects.equals(this.userbaseActive, value)) {
            return this;
        }
        return new ImmutableAtlassianScimExtension(this, this.legacyUnicornUsername, this.description, this.attributes, this.previousId, this.managementAccess, this.privilege, this.location, this.companyName, this.department, this.position, this.validatedEmails, this.googleId, this.samlId, this.latestIpAddress, this.profileActive, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAtlassianScimExtension && this.equalTo((ImmutableAtlassianScimExtension)another);
    }

    private boolean equalTo(ImmutableAtlassianScimExtension another) {
        return Objects.equals(this.legacyUnicornUsername, another.legacyUnicornUsername) && Objects.equals(this.description, another.description) && Objects.equals(this.attributes, another.attributes) && Objects.equals(this.previousId, another.previousId) && Objects.equals((Object)this.managementAccess, (Object)another.managementAccess) && Objects.equals((Object)this.privilege, (Object)another.privilege) && Objects.equals(this.location, another.location) && Objects.equals(this.companyName, another.companyName) && Objects.equals(this.department, another.department) && Objects.equals(this.position, another.position) && Objects.equals(this.validatedEmails, another.validatedEmails) && Objects.equals(this.googleId, another.googleId) && Objects.equals(this.samlId, another.samlId) && Objects.equals(this.latestIpAddress, another.latestIpAddress) && Objects.equals(this.profileActive, another.profileActive) && Objects.equals(this.userbaseActive, another.userbaseActive);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.legacyUnicornUsername);
        h = h * 17 + Objects.hashCode(this.description);
        h = h * 17 + Objects.hashCode(this.attributes);
        h = h * 17 + Objects.hashCode(this.previousId);
        h = h * 17 + Objects.hashCode((Object)this.managementAccess);
        h = h * 17 + Objects.hashCode((Object)this.privilege);
        h = h * 17 + Objects.hashCode(this.location);
        h = h * 17 + Objects.hashCode(this.companyName);
        h = h * 17 + Objects.hashCode(this.department);
        h = h * 17 + Objects.hashCode(this.position);
        h = h * 17 + Objects.hashCode(this.validatedEmails);
        h = h * 17 + Objects.hashCode(this.googleId);
        h = h * 17 + Objects.hashCode(this.samlId);
        h = h * 17 + Objects.hashCode(this.latestIpAddress);
        h = h * 17 + Objects.hashCode(this.profileActive);
        h = h * 17 + Objects.hashCode(this.userbaseActive);
        return h;
    }

    public String toString() {
        return "AtlassianScimExtension{legacyUnicornUsername=" + this.legacyUnicornUsername + ", description=" + this.description + ", attributes=" + this.attributes + ", previousId=" + this.previousId + ", managementAccess=" + (Object)((Object)this.managementAccess) + ", privilege=" + (Object)((Object)this.privilege) + ", location=" + this.location + ", companyName=" + this.companyName + ", department=" + this.department + ", position=" + this.position + ", validatedEmails=" + this.validatedEmails + ", googleId=" + this.googleId + ", samlId=" + this.samlId + ", latestIpAddress=" + this.latestIpAddress + ", profileActive=" + this.profileActive + ", userbaseActive=" + this.userbaseActive + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAtlassianScimExtension fromJson(Json json) {
        Builder builder = ImmutableAtlassianScimExtension.builder();
        if (json.legacyUnicornUsername != null) {
            builder.withLegacyUnicornUsername(json.legacyUnicornUsername);
        }
        if (json.description != null) {
            builder.withDescription(json.description);
        }
        if (json.attributes != null) {
            builder.addAllAttributes(json.attributes);
        }
        if (json.previousId != null) {
            builder.withPreviousId(json.previousId);
        }
        if (json.managementAccess != null) {
            builder.withManagementAccess(json.managementAccess);
        }
        if (json.privilege != null) {
            builder.withPrivilege(json.privilege);
        }
        if (json.location != null) {
            builder.withLocation(json.location);
        }
        if (json.companyName != null) {
            builder.withCompanyName(json.companyName);
        }
        if (json.department != null) {
            builder.withDepartment(json.department);
        }
        if (json.position != null) {
            builder.withPosition(json.position);
        }
        if (json.validatedEmails != null) {
            builder.addAllValidatedEmails(json.validatedEmails);
        }
        if (json.googleId != null) {
            builder.withGoogleId(json.googleId);
        }
        if (json.samlId != null) {
            builder.withSamlId(json.samlId);
        }
        if (json.latestIpAddress != null) {
            builder.withLatestIpAddress(json.latestIpAddress);
        }
        if (json.profileActive != null) {
            builder.withProfileActive(json.profileActive);
        }
        if (json.userbaseActive != null) {
            builder.withUserbaseActive(json.userbaseActive);
        }
        return builder.build();
    }

    public static ImmutableAtlassianScimExtension of(@Nullable String legacyUnicornUsername, @Nullable String description, @Nullable List<ScimAttribute> attributes, @Nullable String previousId, @Nullable ScimGroupManagementAccess managementAccess, @Nullable ScimGroupPrivilege privilege, @Nullable String location, @Nullable String companyName, @Nullable String department, @Nullable String position, @Nullable List<String> validatedEmails, @Nullable String googleId, @Nullable String samlId, @Nullable String latestIpAddress, @Nullable Boolean profileActive, @Nullable Boolean userbaseActive) {
        return ImmutableAtlassianScimExtension.of(legacyUnicornUsername, description, attributes, previousId, managementAccess, privilege, location, companyName, department, position, validatedEmails, googleId, samlId, latestIpAddress, profileActive, userbaseActive);
    }

    public static ImmutableAtlassianScimExtension of(@Nullable String legacyUnicornUsername, @Nullable String description, @Nullable Iterable<? extends ScimAttribute> attributes, @Nullable String previousId, @Nullable ScimGroupManagementAccess managementAccess, @Nullable ScimGroupPrivilege privilege, @Nullable String location, @Nullable String companyName, @Nullable String department, @Nullable String position, @Nullable Iterable<String> validatedEmails, @Nullable String googleId, @Nullable String samlId, @Nullable String latestIpAddress, @Nullable Boolean profileActive, @Nullable Boolean userbaseActive) {
        return new ImmutableAtlassianScimExtension(legacyUnicornUsername, description, attributes, previousId, managementAccess, privilege, location, companyName, department, position, validatedEmails, googleId, samlId, latestIpAddress, profileActive, userbaseActive);
    }

    public static ImmutableAtlassianScimExtension copyOf(AtlassianScimExtension instance) {
        if (instance instanceof ImmutableAtlassianScimExtension) {
            return (ImmutableAtlassianScimExtension)instance;
        }
        return ImmutableAtlassianScimExtension.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String legacyUnicornUsername;
        @Nullable
        private String description;
        private List<ScimAttribute> attributes = null;
        @Nullable
        private String previousId;
        @Nullable
        private ScimGroupManagementAccess managementAccess;
        @Nullable
        private ScimGroupPrivilege privilege;
        @Nullable
        private String location;
        @Nullable
        private String companyName;
        @Nullable
        private String department;
        @Nullable
        private String position;
        private List<String> validatedEmails = null;
        @Nullable
        private String googleId;
        @Nullable
        private String samlId;
        @Nullable
        private String latestIpAddress;
        @Nullable
        private Boolean profileActive;
        @Nullable
        private Boolean userbaseActive;

        private Builder() {
        }

        public final Builder from(AtlassianScimExtension instance) {
            Boolean userbaseActiveValue;
            Boolean profileActiveValue;
            String latestIpAddressValue;
            String samlIdValue;
            String googleIdValue;
            List<String> validatedEmailsValue;
            String positionValue;
            String departmentValue;
            String companyNameValue;
            String locationValue;
            ScimGroupPrivilege privilegeValue;
            ScimGroupManagementAccess managementAccessValue;
            String previousIdValue;
            List<ScimAttribute> attributesValue;
            String descriptionValue;
            Objects.requireNonNull(instance, "instance");
            String legacyUnicornUsernameValue = instance.getLegacyUnicornUsername();
            if (legacyUnicornUsernameValue != null) {
                this.withLegacyUnicornUsername(legacyUnicornUsernameValue);
            }
            if ((descriptionValue = instance.getDescription()) != null) {
                this.withDescription(descriptionValue);
            }
            if ((attributesValue = instance.getAttributes()) != null) {
                this.addAllAttributes(attributesValue);
            }
            if ((previousIdValue = instance.getPreviousId()) != null) {
                this.withPreviousId(previousIdValue);
            }
            if ((managementAccessValue = instance.getManagementAccess()) != null) {
                this.withManagementAccess(managementAccessValue);
            }
            if ((privilegeValue = instance.getPrivilege()) != null) {
                this.withPrivilege(privilegeValue);
            }
            if ((locationValue = instance.getLocation()) != null) {
                this.withLocation(locationValue);
            }
            if ((companyNameValue = instance.getCompanyName()) != null) {
                this.withCompanyName(companyNameValue);
            }
            if ((departmentValue = instance.getDepartment()) != null) {
                this.withDepartment(departmentValue);
            }
            if ((positionValue = instance.getPosition()) != null) {
                this.withPosition(positionValue);
            }
            if ((validatedEmailsValue = instance.getValidatedEmails()) != null) {
                this.addAllValidatedEmails(validatedEmailsValue);
            }
            if ((googleIdValue = instance.getGoogleId()) != null) {
                this.withGoogleId(googleIdValue);
            }
            if ((samlIdValue = instance.getSamlId()) != null) {
                this.withSamlId(samlIdValue);
            }
            if ((latestIpAddressValue = instance.getLatestIpAddress()) != null) {
                this.withLatestIpAddress(latestIpAddressValue);
            }
            if ((profileActiveValue = instance.isProfileActive()) != null) {
                this.withProfileActive(profileActiveValue);
            }
            if ((userbaseActiveValue = instance.isUserbaseActive()) != null) {
                this.withUserbaseActive(userbaseActiveValue);
            }
            return this;
        }

        public final Builder withLegacyUnicornUsername(@Nullable String legacyUnicornUsername) {
            this.legacyUnicornUsername = legacyUnicornUsername;
            return this;
        }

        public final Builder withDescription(@Nullable String description) {
            this.description = description;
            return this;
        }

        public final Builder addAttributes(ScimAttribute element) {
            if (this.attributes == null) {
                this.attributes = new ArrayList<ScimAttribute>();
            }
            this.attributes.add(Objects.requireNonNull(element, "attributes element"));
            return this;
        }

        public final Builder addAttributes(ScimAttribute ... elements) {
            if (this.attributes == null) {
                this.attributes = new ArrayList<ScimAttribute>();
            }
            for (ScimAttribute element : elements) {
                this.attributes.add(Objects.requireNonNull(element, "attributes element"));
            }
            return this;
        }

        public final Builder withAttributes(@Nullable Iterable<? extends ScimAttribute> elements) {
            if (elements == null) {
                this.attributes = null;
                return this;
            }
            this.attributes = new ArrayList<ScimAttribute>();
            return this.addAllAttributes(elements);
        }

        public final Builder addAllAttributes(Iterable<? extends ScimAttribute> elements) {
            Objects.requireNonNull(elements, "attributes element");
            if (this.attributes == null) {
                this.attributes = new ArrayList<ScimAttribute>();
            }
            for (ScimAttribute scimAttribute : elements) {
                this.attributes.add(Objects.requireNonNull(scimAttribute, "attributes element"));
            }
            return this;
        }

        public final Builder withPreviousId(@Nullable String previousId) {
            this.previousId = previousId;
            return this;
        }

        public final Builder withManagementAccess(@Nullable ScimGroupManagementAccess managementAccess) {
            this.managementAccess = managementAccess;
            return this;
        }

        public final Builder withPrivilege(@Nullable ScimGroupPrivilege privilege) {
            this.privilege = privilege;
            return this;
        }

        public final Builder withLocation(@Nullable String location) {
            this.location = location;
            return this;
        }

        public final Builder withCompanyName(@Nullable String companyName) {
            this.companyName = companyName;
            return this;
        }

        public final Builder withDepartment(@Nullable String department) {
            this.department = department;
            return this;
        }

        public final Builder withPosition(@Nullable String position) {
            this.position = position;
            return this;
        }

        public final Builder addValidatedEmails(String element) {
            if (this.validatedEmails == null) {
                this.validatedEmails = new ArrayList<String>();
            }
            this.validatedEmails.add(Objects.requireNonNull(element, "validatedEmails element"));
            return this;
        }

        public final Builder addValidatedEmails(String ... elements) {
            if (this.validatedEmails == null) {
                this.validatedEmails = new ArrayList<String>();
            }
            for (String element : elements) {
                this.validatedEmails.add(Objects.requireNonNull(element, "validatedEmails element"));
            }
            return this;
        }

        public final Builder withValidatedEmails(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.validatedEmails = null;
                return this;
            }
            this.validatedEmails = new ArrayList<String>();
            return this.addAllValidatedEmails(elements);
        }

        public final Builder addAllValidatedEmails(Iterable<String> elements) {
            Objects.requireNonNull(elements, "validatedEmails element");
            if (this.validatedEmails == null) {
                this.validatedEmails = new ArrayList<String>();
            }
            for (String element : elements) {
                this.validatedEmails.add(Objects.requireNonNull(element, "validatedEmails element"));
            }
            return this;
        }

        public final Builder withGoogleId(@Nullable String googleId) {
            this.googleId = googleId;
            return this;
        }

        public final Builder withSamlId(@Nullable String samlId) {
            this.samlId = samlId;
            return this;
        }

        public final Builder withLatestIpAddress(@Nullable String latestIpAddress) {
            this.latestIpAddress = latestIpAddress;
            return this;
        }

        public final Builder withProfileActive(@Nullable Boolean profileActive) {
            this.profileActive = profileActive;
            return this;
        }

        public final Builder withUserbaseActive(@Nullable Boolean userbaseActive) {
            this.userbaseActive = userbaseActive;
            return this;
        }

        public ImmutableAtlassianScimExtension build() {
            return new ImmutableAtlassianScimExtension(null, this.legacyUnicornUsername, this.description, this.attributes == null ? null : ImmutableAtlassianScimExtension.createUnmodifiableList(true, this.attributes), this.previousId, this.managementAccess, this.privilege, this.location, this.companyName, this.department, this.position, this.validatedEmails == null ? null : ImmutableAtlassianScimExtension.createUnmodifiableList(true, this.validatedEmails), this.googleId, this.samlId, this.latestIpAddress, this.profileActive, this.userbaseActive);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends AtlassianScimExtension {
        @Nullable
        String legacyUnicornUsername;
        @Nullable
        String description;
        List<ScimAttribute> attributes = null;
        @Nullable
        String previousId;
        @Nullable
        ScimGroupManagementAccess managementAccess;
        @Nullable
        ScimGroupPrivilege privilege;
        @Nullable
        String location;
        @Nullable
        String companyName;
        @Nullable
        String department;
        @Nullable
        String position;
        List<String> validatedEmails = null;
        @Nullable
        String googleId;
        @Nullable
        String samlId;
        @Nullable
        String latestIpAddress;
        @Nullable
        Boolean profileActive;
        @Nullable
        Boolean userbaseActive;

        Json() {
        }

        @JsonProperty
        public void setLegacyUnicornUsername(@Nullable String legacyUnicornUsername) {
            this.legacyUnicornUsername = legacyUnicornUsername;
        }

        @JsonProperty
        public void setDescription(@Nullable String description) {
            this.description = description;
        }

        @JsonProperty
        public void setAttributes(@Nullable List<ScimAttribute> attributes) {
            this.attributes = attributes;
        }

        @JsonProperty
        public void setPreviousId(@Nullable String previousId) {
            this.previousId = previousId;
        }

        @JsonProperty
        public void setManagementAccess(@Nullable ScimGroupManagementAccess managementAccess) {
            this.managementAccess = managementAccess;
        }

        @JsonProperty
        public void setPrivilege(@Nullable ScimGroupPrivilege privilege) {
            this.privilege = privilege;
        }

        @JsonProperty
        public void setLocation(@Nullable String location) {
            this.location = location;
        }

        @JsonProperty
        public void setCompanyName(@Nullable String companyName) {
            this.companyName = companyName;
        }

        @JsonProperty
        public void setDepartment(@Nullable String department) {
            this.department = department;
        }

        @JsonProperty
        public void setPosition(@Nullable String position) {
            this.position = position;
        }

        @JsonProperty
        public void setValidatedEmails(@Nullable List<String> validatedEmails) {
            this.validatedEmails = validatedEmails;
        }

        @JsonProperty
        public void setGoogleId(@Nullable String googleId) {
            this.googleId = googleId;
        }

        @JsonProperty
        public void setSamlId(@Nullable String samlId) {
            this.samlId = samlId;
        }

        @JsonProperty
        public void setLatestIpAddress(@Nullable String latestIpAddress) {
            this.latestIpAddress = latestIpAddress;
        }

        @JsonProperty
        public void setProfileActive(@Nullable Boolean profileActive) {
            this.profileActive = profileActive;
        }

        @JsonProperty
        public void setUserbaseActive(@Nullable Boolean userbaseActive) {
            this.userbaseActive = userbaseActive;
        }

        @Override
        public String getLegacyUnicornUsername() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDescription() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ScimAttribute> getAttributes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPreviousId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ScimGroupManagementAccess getManagementAccess() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ScimGroupPrivilege getPrivilege() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getLocation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCompanyName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDepartment() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPosition() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getValidatedEmails() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getGoogleId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSamlId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getLatestIpAddress() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean isProfileActive() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean isUserbaseActive() {
            throw new UnsupportedOperationException();
        }
    }
}

