/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.apache.httpcomponents.proxy;

import com.atlassian.fugue.Option;
import com.atlassian.fugue.Options;
import com.atlassian.httpclient.apache.httpcomponents.proxy.ProxyConfig;
import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;

public class SystemPropertiesProxyConfig
extends ProxyConfig {
    private static final Iterable<String> SUPPORTED_SCHEMAS = Lists.newArrayList((Object[])new String[]{"http", "https"});
    private static Splitter NON_PROXY_HOST_SPLITTER = Splitter.on((char)'|');

    @Override
    Iterable<HttpHost> getProxyHosts() {
        Iterable proxyHosts = Iterables.transform(SUPPORTED_SCHEMAS, (Function)new Function<String, Option<HttpHost>>(){

            public Option<HttpHost> apply(String schema) {
                return SystemPropertiesProxyConfig.getProxy(schema);
            }
        });
        return Options.flatten((Iterable)Options.filterNone((Iterable)proxyHosts));
    }

    @Override
    public Iterable<ProxyConfig.AuthenticationInfo> getAuthenticationInfo() {
        return Iterables.transform(this.getProxyHosts(), (Function)new Function<HttpHost, ProxyConfig.AuthenticationInfo>(){

            public ProxyConfig.AuthenticationInfo apply(HttpHost httpHost) {
                AuthScope authScope = new AuthScope(httpHost);
                Option credentials = SystemPropertiesProxyConfig.credentialsForScheme(httpHost.getSchemeName());
                return new ProxyConfig.AuthenticationInfo(authScope, (Option<Credentials>)credentials);
            }
        });
    }

    private static Option<HttpHost> getProxy(String schemeName) {
        String proxyHost = System.getProperty(schemeName + ".proxyHost");
        if (proxyHost != null) {
            return Option.some((Object)new HttpHost(proxyHost, Integer.parseInt(System.getProperty(schemeName + ".proxyPort")), schemeName));
        }
        return Option.none();
    }

    private static List<String> getNonProxyHosts(String schemeName) {
        String nonProxyHosts = System.getProperty(schemeName + ".nonProxyHosts");
        if (nonProxyHosts != null) {
            return Lists.newArrayList((Iterable)NON_PROXY_HOST_SPLITTER.split((CharSequence)nonProxyHosts));
        }
        return ImmutableList.of();
    }

    private static Option<Credentials> credentialsForScheme(String schemeName) {
        String username = System.getProperty(schemeName + ".proxyUser");
        if (username != null) {
            String proxyPassword = System.getProperty(schemeName + ".proxyPassword");
            String proxyAuth = System.getProperty(schemeName + ".proxyAuth");
            if (proxyAuth == null || proxyAuth.equalsIgnoreCase("basic")) {
                return Option.some((Object)new UsernamePasswordCredentials(username, proxyPassword));
            }
            if (proxyAuth.equalsIgnoreCase("digest") || proxyAuth.equalsIgnoreCase("ntlm")) {
                String ntlmDomain = System.getProperty(schemeName + ".proxyNtlmDomain");
                String ntlmWorkstation = System.getProperty(schemeName + ".proxyNtlmWorkstation");
                return Option.some((Object)new NTCredentials(username, proxyPassword, StringUtils.defaultString((String)ntlmWorkstation), StringUtils.defaultString((String)ntlmDomain)));
            }
            return Option.none();
        }
        return Option.none();
    }
}

