/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.apache.httpcomponents;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import org.apache.http.HttpHost;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.reactor.ssl.SSLIOSession;
import org.apache.http.nio.reactor.ssl.SSLMode;
import org.apache.http.nio.reactor.ssl.SSLSetupHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DHEDisabledSSLSessionStrategy
extends SSLIOSessionStrategy {
    private static final String DHE_CIPHER_PREFIX = "TLS_DHE";
    private final Iterable<String> hostBlacklist;
    private final SSLContext sslContext;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String[] httpsCipherSuites;
    private final String[] httpsProtocols;

    public DHEDisabledSSLSessionStrategy(SSLContext sslContext, List<String> hostBlacklist, @Nullable String[] httpsProtocols, @Nullable String[] httpsCipherSuites, X509HostnameVerifier hostnameVerifier) {
        super(sslContext, httpsProtocols, httpsCipherSuites, hostnameVerifier);
        this.sslContext = (SSLContext)Preconditions.checkNotNull((Object)sslContext, (Object)"SSL context");
        SSLParameters sslParams = sslContext.getDefaultSSLParameters();
        Preconditions.checkNotNull((Object)hostnameVerifier);
        this.hostBlacklist = (Iterable)Preconditions.checkNotNull(hostBlacklist);
        this.httpsProtocols = httpsProtocols != null ? httpsProtocols : sslParams.getProtocols();
        this.httpsCipherSuites = httpsCipherSuites != null ? httpsCipherSuites : sslParams.getCipherSuites();
    }

    public DHEDisabledSSLSessionStrategy(SSLContext sslContext) {
        super(sslContext);
        this.sslContext = sslContext;
        SSLParameters sslParams = sslContext.getDefaultSSLParameters();
        this.hostBlacklist = Lists.newArrayList();
        this.httpsCipherSuites = sslParams.getCipherSuites();
        this.httpsProtocols = sslParams.getProtocols();
    }

    @Override
    public SSLIOSession upgrade(HttpHost host, IOSession ioSession) throws IOException {
        SSLIOSession sslIOSession = new SSLIOSession(ioSession, SSLMode.CLIENT, host, this.sslContext, new NonDHESSLSetupHandler(host));
        ioSession.setAttribute("http.session.ssl", sslIOSession);
        sslIOSession.initialize();
        return sslIOSession;
    }

    private String[] getNonDHECiphers() {
        List<String> ciphers = Arrays.asList(this.httpsCipherSuites);
        Iterable nonDHECiphers = Iterables.filter(ciphers, (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return !input.startsWith(DHEDisabledSSLSessionStrategy.DHE_CIPHER_PREFIX);
            }
        });
        String[] nonDHECipherSuites = (String[])Iterables.toArray((Iterable)nonDHECiphers, String.class);
        return nonDHECipherSuites;
    }

    private final class NonDHESSLSetupHandler
    implements SSLSetupHandler {
        private final HttpHost host;

        private NonDHESSLSetupHandler(HttpHost host) {
            this.host = host;
        }

        @Override
        public void initalize(SSLEngine sslEngine) throws SSLException {
            if (Iterables.contains((Iterable)DHEDisabledSSLSessionStrategy.this.hostBlacklist, (Object)this.host.getHostName())) {
                if (DHEDisabledSSLSessionStrategy.this.log.isDebugEnabled()) {
                    DHEDisabledSSLSessionStrategy.this.log.debug("Disabling dhe for host: " + this.host.getHostName());
                }
                sslEngine.setEnabledCipherSuites(DHEDisabledSSLSessionStrategy.this.getNonDHECiphers());
            } else {
                if (DHEDisabledSSLSessionStrategy.this.log.isDebugEnabled()) {
                    DHEDisabledSSLSessionStrategy.this.log.debug("Enabling DHE for host: " + this.host.getHostName());
                }
                sslEngine.setEnabledCipherSuites(DHEDisabledSSLSessionStrategy.this.httpsCipherSuites);
            }
            sslEngine.setEnabledProtocols(DHEDisabledSSLSessionStrategy.this.httpsProtocols);
            DHEDisabledSSLSessionStrategy.this.initializeEngine(sslEngine);
        }

        @Override
        public void verify(IOSession iosession, SSLSession sslsession) throws SSLException {
            DHEDisabledSSLSessionStrategy.this.verifySession(this.host, iosession, sslsession);
        }
    }
}

