/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.apache.httpcomponents;

import java.io.IOException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.apache.http.HttpHost;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.reactor.ssl.SSLIOSession;
import org.apache.http.nio.reactor.ssl.SSLMode;
import org.apache.http.nio.reactor.ssl.SSLSetupHandler;
import org.apache.http.util.Args;
import org.apache.http.util.Asserts;

class SniCompatibleSSLIOSessionStrategy
extends SSLIOSessionStrategy {
    private final SSLContext sslContext;
    private final String[] supportedProtocols;
    private final String[] supportedCipherSuites;

    public SniCompatibleSSLIOSessionStrategy(SSLContext sslContext, String[] supportedProtocols, String[] supportedCipherSuites, X509HostnameVerifier hostnameVerifier) {
        super(sslContext, supportedProtocols, supportedCipherSuites, hostnameVerifier);
        this.sslContext = Args.notNull(sslContext, "SSL context");
        this.supportedProtocols = supportedProtocols;
        this.supportedCipherSuites = supportedCipherSuites;
    }

    @Override
    public SSLIOSession upgrade(final HttpHost host, IOSession iosession) throws IOException {
        Asserts.check(!(iosession instanceof SSLIOSession), "I/O session is already upgraded to TLS/SSL");
        SSLIOSession ssliosession = new SSLIOSession(iosession, SSLMode.CLIENT, host, this.sslContext, new SSLSetupHandler(){

            @Override
            public void initalize(SSLEngine sslengine) throws SSLException {
                if (SniCompatibleSSLIOSessionStrategy.this.supportedProtocols != null) {
                    sslengine.setEnabledProtocols(SniCompatibleSSLIOSessionStrategy.this.supportedProtocols);
                }
                if (SniCompatibleSSLIOSessionStrategy.this.supportedCipherSuites != null) {
                    sslengine.setEnabledCipherSuites(SniCompatibleSSLIOSessionStrategy.this.supportedCipherSuites);
                }
                SniCompatibleSSLIOSessionStrategy.this.initializeEngine(sslengine);
            }

            @Override
            public void verify(IOSession iosession, SSLSession sslsession) throws SSLException {
                SniCompatibleSSLIOSessionStrategy.this.verifySession(host, iosession, sslsession);
            }
        });
        iosession.setAttribute("http.session.ssl", ssliosession);
        ssliosession.initialize();
        return ssliosession;
    }
}

