/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.apache.httpcomponents;

import com.atlassian.fugue.Option;
import com.atlassian.httpclient.apache.httpcomponents.HttpClientProxyConfig;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.conn.params.ConnRouteParams;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.nio.conn.scheme.AsyncScheme;
import org.apache.http.nio.conn.scheme.AsyncSchemeRegistry;
import org.apache.http.protocol.HttpContext;

public class ProxyRoutePlanner
implements HttpRoutePlanner {
    private final AsyncSchemeRegistry schemeRegistry;
    private final HttpClientProxyConfig proxyConfig;

    public ProxyRoutePlanner(AsyncSchemeRegistry schemeRegistry, HttpClientProxyConfig proxyConfig) {
        this.schemeRegistry = schemeRegistry;
        this.proxyConfig = proxyConfig;
    }

    @Override
    public HttpRoute determineRoute(final HttpHost targetHost, final HttpRequest request, HttpContext httpContext) throws HttpException {
        Preconditions.checkNotNull((Object)request);
        Preconditions.checkNotNull((Object)targetHost);
        HttpRoute forcedRoute = ConnRouteParams.getForcedRoute(request.getParams());
        if (forcedRoute != null) {
            return forcedRoute;
        }
        Option<HttpHost> proxy = this.getProxy(targetHost);
        return (HttpRoute)proxy.fold((Supplier)new Supplier<HttpRoute>(){

            public HttpRoute get() {
                return new HttpRoute(targetHost, ConnRouteParams.getLocalAddress(request.getParams()), ProxyRoutePlanner.this.isSecure(targetHost));
            }
        }, (Function)new Function<HttpHost, HttpRoute>(){

            public HttpRoute apply(HttpHost proxy) {
                return new HttpRoute(targetHost, ConnRouteParams.getLocalAddress(request.getParams()), proxy, ProxyRoutePlanner.this.isSecure(targetHost));
            }
        });
    }

    private Option<HttpHost> getProxy(HttpHost targetHost) {
        AsyncScheme scheme = this.schemeRegistry.getScheme(targetHost);
        if (this.isNonProxyHost(targetHost)) {
            return Option.none();
        }
        return this.proxyConfig.getProxy(scheme);
    }

    private boolean isNonProxyHost(HttpHost targetHost) {
        return this.proxyConfig.getNonProxyHosts(this.schemeRegistry.getScheme(targetHost)).contains(targetHost.getHostName());
    }

    private boolean isSecure(HttpHost target) {
        AsyncScheme scheme = this.schemeRegistry.getScheme(target.getSchemeName());
        return "https".equalsIgnoreCase(scheme.getName());
    }
}

