/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.apache.httpcomponents;

import com.atlassian.fugue.Effect;
import com.atlassian.fugue.Option;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.impl.nio.client.AbstractHttpAsyncClient;
import org.apache.http.nio.conn.scheme.AsyncScheme;
import org.apache.http.nio.conn.scheme.AsyncSchemeRegistry;

public class HttpClientProxyConfig {
    private static Splitter NON_PROXY_HOST_SPLITTER = Splitter.on((char)'|');

    private HttpClientProxyConfig() {
    }

    public static Option<HttpHost> getProxy(AsyncScheme scheme) {
        return HttpClientProxyConfig.getProxy(scheme.getName().toLowerCase());
    }

    private static Option<HttpHost> getProxy(String schemeName) {
        String proxyHost = System.getProperty(schemeName + ".proxyHost");
        if (proxyHost != null) {
            return Option.some(new HttpHost(proxyHost, Integer.parseInt(System.getProperty(schemeName + ".proxyPort")), schemeName));
        }
        return Option.none();
    }

    public static List<String> getNonProxyHosts(AsyncScheme scheme) {
        return HttpClientProxyConfig.getNonProxyHosts(scheme.getName().toLowerCase());
    }

    private static List<String> getNonProxyHosts(String schemeName) {
        String nonProxyHosts = System.getProperty(schemeName + ".nonProxyHosts");
        if (nonProxyHosts != null) {
            return Lists.newArrayList((Iterable)NON_PROXY_HOST_SPLITTER.split((CharSequence)nonProxyHosts));
        }
        return ImmutableList.of();
    }

    public static void applyProxyCredentials(AbstractHttpAsyncClient client, AsyncSchemeRegistry schemeRegistry) {
        for (String scheme : schemeRegistry.getSchemeNames()) {
            HttpClientProxyConfig.applyProxyCredentials(client, scheme.toLowerCase());
        }
    }

    private static void applyProxyCredentials(final AbstractHttpAsyncClient client, final String schemeName) {
        Option<HttpHost> proxy = HttpClientProxyConfig.getProxy(schemeName);
        proxy.foreach(new Effect<HttpHost>(){

            @Override
            public void apply(final HttpHost httpHost) {
                ProxyAuthentication.forScheme(schemeName).foreach(new Effect<ProxyAuthentication>(){

                    @Override
                    public void apply(ProxyAuthentication proxyAuthentication) {
                        proxyAuthentication.apply(client, httpHost);
                    }
                });
            }
        });
    }

    private static class ProxyAuthentication {
        private final String scheme;
        private final Credentials credentials;

        ProxyAuthentication(String scheme, Credentials credentials) {
            this.scheme = scheme;
            this.credentials = credentials;
        }

        public void apply(AbstractHttpAsyncClient client, HttpHost httpHost) {
            AuthScope scope = new AuthScope(httpHost.getHostName(), httpHost.getPort(), null, this.scheme);
            client.getCredentialsProvider().setCredentials(scope, this.credentials);
        }

        public static Option<ProxyAuthentication> forScheme(String schemeName) {
            String username = System.getProperty(schemeName + ".proxyUser");
            if (username != null) {
                String proxyPassword = System.getProperty(schemeName + ".proxyPassword");
                String proxyAuth = System.getProperty(schemeName + ".proxyAuth");
                if (proxyAuth == null || proxyAuth.equalsIgnoreCase("basic")) {
                    return Option.some(new ProxyAuthentication("basic", new UsernamePasswordCredentials(username, proxyPassword)));
                }
                if (proxyAuth.equalsIgnoreCase("digest") || proxyAuth.equalsIgnoreCase("ntlm")) {
                    String ntlmDomain = System.getProperty(schemeName + ".proxyNtlmDomain");
                    String ntlmWorkstation = System.getProperty(schemeName + ".proxyNtlmWorkstation");
                    return Option.some(new ProxyAuthentication(proxyAuth.toLowerCase(), new NTCredentials(username, proxyPassword, StringUtils.defaultString((String)ntlmWorkstation), StringUtils.defaultString((String)ntlmDomain))));
                }
                return Option.none();
            }
            return Option.none();
        }
    }
}

