/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.apache.httpcomponents;

import com.atlassian.fugue.Option;
import com.atlassian.httpclient.apache.httpcomponents.DefaultAttributes;
import com.atlassian.httpclient.apache.httpcomponents.DefaultRequest;
import com.atlassian.httpclient.apache.httpcomponents.HeadersBuilder;
import com.atlassian.httpclient.api.Entity;
import com.atlassian.httpclient.api.Headers;
import com.atlassian.httpclient.api.Request;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Map;

public class RequestBuilder
implements Request.Builder {
    private URI uri;
    private Request.Method method;
    private Option<Entity> entity = Option.none();
    private final ImmutableMap.Builder<String, String> attributes = ImmutableMap.builder();
    private final Headers.Builder headers = HeadersBuilder.builder();

    static Request.Builder builder() {
        return new RequestBuilder();
    }

    private RequestBuilder() {
    }

    @Override
    public Request build() {
        return new DefaultRequest((Headers)this.headers.build(), this.entity, this.method, this.uri, new DefaultAttributes((Map<String, String>)this.attributes.build()));
    }

    @Override
    public Request.Builder setAccept(String accept) {
        this.headers.setAccept(accept);
        return this;
    }

    @Override
    public Request.Builder setAttribute(String name, String value) {
        this.attributes.put((Object)name, (Object)value);
        return this;
    }

    @Override
    public Request.Builder setAttributes(Map<String, String> attrs) {
        this.attributes.putAll(attrs);
        return this;
    }

    @Override
    public Request.Builder setEntity(String entity) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Request.Builder setEntity(Entity entity) {
        this.entity = Option.some(entity);
        return this;
    }

    @Override
    public Request.Builder setHeaders(Headers headers) {
        this.headers.addAll(headers);
        return this;
    }

    @Override
    public Request.Builder setMethod(Request.Method method) {
        this.method = method;
        return this;
    }

    @Override
    public Request.Builder uri(URI uri) {
        this.uri = uri;
        return this;
    }

    @Override
    public Request.Builder url(String url) {
        return this.uri(URI.create(url));
    }

    @Override
    public Request.Builder get() {
        this.setMethod(Request.Method.GET);
        return this;
    }

    @Override
    public Request.Builder post() {
        this.setMethod(Request.Method.POST);
        return this;
    }

    @Override
    public Request.Builder put() {
        this.setMethod(Request.Method.PUT);
        return this;
    }

    @Override
    public Request.Builder delete() {
        this.setMethod(Request.Method.DELETE);
        return this;
    }

    @Override
    public Request.Builder options() {
        this.setMethod(Request.Method.OPTIONS);
        return this;
    }

    @Override
    public Request.Builder head() {
        this.setMethod(Request.Method.HEAD);
        return this;
    }

    @Override
    public Request.Builder trace() {
        this.setMethod(Request.Method.TRACE);
        return this;
    }
}

