/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.api;

import com.atlassian.httpclient.api.BaseResponsePromise;
import com.atlassian.httpclient.api.HttpStatus;
import com.atlassian.httpclient.api.Response;
import com.atlassian.httpclient.api.ResponsePromiseMapFunction;
import com.atlassian.httpclient.api.ResponseTransformationException;
import com.atlassian.util.concurrent.Promise;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class ResponsePromiseTransformationBuilder<O> {
    private final BaseResponsePromise<Response> baseResponsePromise;
    private final Map<ResponsePromiseMapFunction.StatusRange, Function<Response, ? extends O>> functions;
    private Function<Response, ? extends O> othersFunction;
    private Function<Throwable, ? extends O> throwableHandler;

    ResponsePromiseTransformationBuilder(BaseResponsePromise<Response> baseResponsePromise) {
        this.baseResponsePromise = (BaseResponsePromise)Preconditions.checkNotNull(baseResponsePromise);
        this.functions = Maps.newHashMap();
    }

    public ResponsePromiseTransformationBuilder<O> informational(Function<Response, ? extends O> f) {
        return this.addRange(HttpStatus.CONTINUE, f);
    }

    public ResponsePromiseTransformationBuilder<O> successful(Function<Response, ? extends O> f) {
        return this.addRange(HttpStatus.OK, f);
    }

    public ResponsePromiseTransformationBuilder<O> ok(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.OK, f);
    }

    public ResponsePromiseTransformationBuilder<O> created(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.CREATED, f);
    }

    public ResponsePromiseTransformationBuilder<O> noContent(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.NO_CONTENT, f);
    }

    public ResponsePromiseTransformationBuilder<O> redirection(Function<Response, ? extends O> f) {
        return this.addRange(HttpStatus.MULTIPLE_CHOICES, f);
    }

    public ResponsePromiseTransformationBuilder<O> seeOther(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.SEE_OTHER, f);
    }

    public ResponsePromiseTransformationBuilder<O> notModified(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.NOT_MODIFIED, f);
    }

    public ResponsePromiseTransformationBuilder<O> clientError(Function<Response, ? extends O> f) {
        return this.addRange(HttpStatus.BAD_REQUEST, f);
    }

    public ResponsePromiseTransformationBuilder<O> badRequest(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.BAD_REQUEST, f);
    }

    public ResponsePromiseTransformationBuilder<O> unauthorized(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.UNAUTHORIZED, f);
    }

    public ResponsePromiseTransformationBuilder<O> forbidden(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.FORBIDDEN, f);
    }

    public ResponsePromiseTransformationBuilder<O> notFound(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.NOT_FOUND, f);
    }

    public ResponsePromiseTransformationBuilder<O> conflict(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.CONFLICT, f);
    }

    public ResponsePromiseTransformationBuilder<O> serverError(Function<Response, ? extends O> f) {
        return this.addRange(HttpStatus.INTERNAL_SERVER_ERROR, f);
    }

    public ResponsePromiseTransformationBuilder<O> internalServerError(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.INTERNAL_SERVER_ERROR, f);
    }

    public ResponsePromiseTransformationBuilder<O> serviceUnavailable(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.SERVICE_UNAVAILABLE, f);
    }

    public ResponsePromiseTransformationBuilder<O> error(Function<Response, ? extends O> f) {
        this.functions.put(new OrStatusRange(new HundredsStatusRange(HttpStatus.BAD_REQUEST), new HundredsStatusRange(HttpStatus.INTERNAL_SERVER_ERROR)), f);
        return this;
    }

    public ResponsePromiseTransformationBuilder<O> notSuccessful(Function<Response, ? extends O> f) {
        this.functions.put(new NotInStatusRange(new HundredsStatusRange(HttpStatus.OK)), f);
        return this;
    }

    public ResponsePromiseTransformationBuilder<O> others(Function<Response, ? extends O> f) {
        this.othersFunction = f;
        return this;
    }

    public ResponsePromiseTransformationBuilder<O> fail(Function<Throwable, ? extends O> f) {
        this.throwableHandler = f;
        return this;
    }

    private ResponsePromiseTransformationBuilder<O> addSingle(HttpStatus status, Function<Response, ? extends O> f) {
        this.functions.put(new SingleStatusRange(status), f);
        return this;
    }

    private ResponsePromiseTransformationBuilder<O> addRange(HttpStatus status, Function<Response, ? extends O> f) {
        this.functions.put(new HundredsStatusRange(status), f);
        return this;
    }

    public Promise<O> toPromise() {
        return this.baseResponsePromise.fold((Function)(this.throwableHandler != null ? this.throwableHandler : this.defaultThrowableHandler()), new ResponsePromiseMapFunction<O>(this.functions, this.othersFunction));
    }

    private Function<Throwable, ? extends O> defaultThrowableHandler() {
        return new Function<Throwable, O>(){

            public O apply(Throwable throwable) {
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw new ResponseTransformationException(throwable);
            }
        };
    }

    static final class OrStatusRange
    implements ResponsePromiseMapFunction.StatusRange {
        private final ResponsePromiseMapFunction.StatusRange one;
        private final ResponsePromiseMapFunction.StatusRange two;

        private OrStatusRange(ResponsePromiseMapFunction.StatusRange one, ResponsePromiseMapFunction.StatusRange two) {
            this.one = (ResponsePromiseMapFunction.StatusRange)Preconditions.checkNotNull((Object)one);
            this.two = (ResponsePromiseMapFunction.StatusRange)Preconditions.checkNotNull((Object)two);
        }

        @Override
        public boolean isIn(int code) {
            return this.one.isIn(code) || this.two.isIn(code);
        }
    }

    static final class NotInStatusRange
    implements ResponsePromiseMapFunction.StatusRange {
        private final ResponsePromiseMapFunction.StatusRange range;

        private NotInStatusRange(ResponsePromiseMapFunction.StatusRange range) {
            this.range = (ResponsePromiseMapFunction.StatusRange)Preconditions.checkNotNull((Object)range);
        }

        @Override
        public boolean isIn(int code) {
            return !this.range.isIn(code);
        }
    }

    static final class HundredsStatusRange
    implements ResponsePromiseMapFunction.StatusRange {
        private final HttpStatus status;

        private HundredsStatusRange(HttpStatus status) {
            this.status = (HttpStatus)((Object)Preconditions.checkNotNull((Object)((Object)status)));
        }

        @Override
        public boolean isIn(int code) {
            int diff = code - this.status.code;
            return 0 <= diff && diff < 100;
        }
    }

    static final class SingleStatusRange
    implements ResponsePromiseMapFunction.StatusRange {
        private final HttpStatus status;

        SingleStatusRange(HttpStatus status) {
            this.status = (HttpStatus)((Object)Preconditions.checkNotNull((Object)((Object)status)));
        }

        @Override
        public boolean isIn(int code) {
            return this.status.code == code;
        }
    }
}

