/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.apache.httpcomponents;

import com.atlassian.httpclient.apache.httpcomponents.DefaultMessage;
import com.atlassian.httpclient.api.EntityBuilder;
import com.atlassian.httpclient.api.Request;
import com.atlassian.httpclient.api.ResponsePromise;
import com.atlassian.httpclient.base.AbstractHttpClient;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.Map;

public class DefaultRequest
extends DefaultMessage
implements Request {
    private final AbstractHttpClient httpClient;
    private Request.Method method;
    private URI uri;
    private boolean cacheDisabled;
    private Map<String, String> attributes;

    public DefaultRequest(AbstractHttpClient httpClient) {
        this.httpClient = (AbstractHttpClient)Preconditions.checkNotNull((Object)httpClient);
        this.attributes = Maps.newHashMap();
        this.setAccept("*/*");
    }

    public DefaultRequest(AbstractHttpClient httpClient, URI uri) {
        this(httpClient, uri, null, null);
    }

    public DefaultRequest(AbstractHttpClient httpClient, URI uri, String contentType, String entity) {
        this(httpClient);
        this.setUri(uri).setContentType(contentType).setEntity(entity);
    }

    public ResponsePromise get() {
        return this.execute(Request.Method.GET);
    }

    public ResponsePromise post() {
        return this.execute(Request.Method.POST);
    }

    public ResponsePromise put() {
        return this.execute(Request.Method.PUT);
    }

    public ResponsePromise delete() {
        return this.execute(Request.Method.DELETE);
    }

    public ResponsePromise options() {
        return this.execute(Request.Method.OPTIONS);
    }

    public ResponsePromise head() {
        return this.execute(Request.Method.HEAD);
    }

    public ResponsePromise trace() {
        return this.execute(Request.Method.TRACE);
    }

    public ResponsePromise execute(Request.Method method) {
        Preconditions.checkNotNull((Object)method, (Object)"HTTP method must not be null");
        this.setMethod(method);
        return this.httpClient.execute(this);
    }

    public Request.Method getMethod() {
        return this.method;
    }

    private Request setMethod(Request.Method method) {
        this.checkMutable();
        this.method = method;
        return this;
    }

    public URI getUri() {
        return this.uri;
    }

    public Request setUri(URI uri) {
        this.checkMutable();
        this.uri = uri;
        return this;
    }

    public String getAccept() {
        return this.getHeader("Accept");
    }

    public Request setAccept(String accept) {
        this.checkMutable();
        this.setHeader("Accept", accept);
        return this;
    }

    public Request setCacheDisabled() {
        this.checkMutable();
        this.cacheDisabled = true;
        return this;
    }

    public Request setAttribute(String name, String value) {
        this.checkMutable();
        this.attributes.put(name, value);
        return this;
    }

    public Request setAttributes(Map<String, String> properties) {
        this.checkMutable();
        this.attributes.putAll(properties);
        return this;
    }

    public String getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public Request setEntity(EntityBuilder entityBuilder) {
        EntityBuilder.Entity entity = entityBuilder.build();
        return this.setHeaders((Map<String, String>)entity.getHeaders()).setEntityStream(entity.getInputStream());
    }

    public Request validate() {
        super.validate();
        Preconditions.checkNotNull((Object)this.uri);
        Preconditions.checkNotNull((Object)this.method);
        switch (this.method) {
            case GET: 
            case DELETE: 
            case HEAD: {
                if (!this.hasEntity()) break;
                throw new IllegalStateException("Request method " + this.method + " does not support an entity");
            }
        }
        return this;
    }

    public Request setContentType(String contentType) {
        super.setContentType(contentType);
        return this;
    }

    public Request setContentCharset(String contentCharset) {
        super.setContentCharset(contentCharset);
        return this;
    }

    public Request setHeaders(Map<String, String> headers) {
        super.setHeaders(headers);
        return this;
    }

    public Request setHeader(String name, String value) {
        super.setHeader(name, value);
        return this;
    }

    public Request setEntity(String entity) {
        super.setEntity(entity);
        return this;
    }

    public Request setEntityStream(InputStream entityStream, String encoding) {
        super.setEntityStream(entityStream, encoding);
        return this;
    }

    public Request setEntityStream(InputStream entityStream) {
        super.setEntityStream(entityStream);
        return this;
    }

    public boolean isCacheDisabled() {
        return this.cacheDisabled;
    }

    protected Request freeze() {
        super.freeze();
        return this;
    }
}

