/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.apache.httpcomponents;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.httpclient.apache.httpcomponents.DefaultRequest;
import com.atlassian.httpclient.apache.httpcomponents.DefaultResponse;
import com.atlassian.httpclient.apache.httpcomponents.FlushableHttpCacheStorage;
import com.atlassian.httpclient.apache.httpcomponents.MavenUtils;
import com.atlassian.httpclient.apache.httpcomponents.PromiseHttpAsyncClient;
import com.atlassian.httpclient.apache.httpcomponents.SettableFuturePromiseHttpPromiseAsyncClient;
import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.httpclient.api.HttpStatus;
import com.atlassian.httpclient.api.Request;
import com.atlassian.httpclient.api.Response;
import com.atlassian.httpclient.api.ResponsePromise;
import com.atlassian.httpclient.api.ResponsePromises;
import com.atlassian.httpclient.api.factory.HttpClientOptions;
import com.atlassian.httpclient.base.AbstractHttpClient;
import com.atlassian.httpclient.base.RequestKiller;
import com.atlassian.httpclient.base.event.HttpRequestCompletedEvent;
import com.atlassian.httpclient.base.event.HttpRequestFailedEvent;
import com.atlassian.httpclient.spi.ThreadLocalContextManager;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.util.concurrent.Promise;
import com.atlassian.util.concurrent.Promises;
import com.atlassian.util.concurrent.ThreadFactories;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.cache.HttpCacheStorage;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.AbortableHttpRequest;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CachingHttpAsyncClient;
import org.apache.http.impl.conn.DefaultSchemePortResolver;
import org.apache.http.impl.conn.SystemDefaultDnsResolver;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.conn.ManagedNHttpClientConnectionFactory;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.client.HttpAsyncClient;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.conn.NHttpConnectionFactory;
import org.apache.http.nio.conn.NoopIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.nio.reactor.IOReactorExceptionHandler;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public final class DefaultHttpClient<C>
extends AbstractHttpClient
implements HttpClient,
DisposableBean {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final EventPublisher eventPublisher;
    private final ApplicationProperties applicationProperties;
    private final ThreadLocalContextManager<C> threadLocalContextManager;
    private final ExecutorService callbackExecutor;
    private final HttpClientOptions httpClientOptions;
    private final RequestKiller requestKiller;
    private final HttpAsyncClient httpClient;
    private final CloseableHttpAsyncClient nonCachingHttpClient;
    private final FlushableHttpCacheStorage httpCacheStorage;

    public DefaultHttpClient(EventPublisher eventPublisher, ApplicationProperties applicationProperties, ThreadLocalContextManager<C> threadLocalContextManager) {
        this(eventPublisher, applicationProperties, threadLocalContextManager, new HttpClientOptions());
    }

    public DefaultHttpClient(EventPublisher eventPublisher, ApplicationProperties applicationProperties, ThreadLocalContextManager<C> threadLocalContextManager, HttpClientOptions options) {
        CloseableHttpAsyncClient client;
        this.eventPublisher = (EventPublisher)Preconditions.checkNotNull((Object)eventPublisher);
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties);
        this.threadLocalContextManager = (ThreadLocalContextManager)Preconditions.checkNotNull(threadLocalContextManager);
        this.httpClientOptions = (HttpClientOptions)Preconditions.checkNotNull((Object)options);
        this.requestKiller = new RequestKiller(options.getThreadPrefix());
        try {
            IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setIoThreadCount(options.getIoThreadCount()).setSelectInterval(options.getIoSelectInterval()).setInterestOpQueued(true).setTcpNoDelay(true).setConnectTimeout((int)options.getConnectionTimeout()).setSoTimeout((int)options.getSocketTimeout()).setRcvBufSize(8192).setSndBufSize(8192).build();
            DefaultConnectingIOReactor reactor = new DefaultConnectingIOReactor(ioReactorConfig, ThreadFactories.namedThreadFactory((String)(options.getThreadPrefix() + "-io"), (ThreadFactories.Type)ThreadFactories.Type.DAEMON));
            reactor.setExceptionHandler(new IOReactorExceptionHandler(){

                public boolean handle(IOException ex) {
                    DefaultHttpClient.this.log.error("IO exception in reactor", (Throwable)ex);
                    return false;
                }

                public boolean handle(RuntimeException ex) {
                    DefaultHttpClient.this.log.error("Fatal runtime error", (Throwable)ex);
                    return false;
                }
            });
            Registry defaultRegistry = RegistryBuilder.create().register("http", (Object)NoopIOSessionStrategy.INSTANCE).register("https", (Object)SSLIOSessionStrategy.getDefaultStrategy()).build();
            PoolingNHttpClientConnectionManager connmgr = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)reactor, (NHttpConnectionFactory)ManagedNHttpClientConnectionFactory.INSTANCE, defaultRegistry, (SchemePortResolver)DefaultSchemePortResolver.INSTANCE, (DnsResolver)SystemDefaultDnsResolver.INSTANCE, options.getConnectionPoolTimeToLive(), TimeUnit.MILLISECONDS){

                protected void finalize() throws Throwable {
                }
            };
            connmgr.setDefaultMaxPerRoute(options.getMaxConnectionsPerHost());
            RequestConfig clientConfig = RequestConfig.custom().setConnectTimeout((int)options.getConnectionTimeout()).setSocketTimeout((int)options.getSocketTimeout()).build();
            client = HttpAsyncClients.custom().setConnectionManager((NHttpClientConnectionManager)connmgr).setDefaultRequestConfig(clientConfig).setUserAgent(this.getUserAgent(options)).build();
        }
        catch (IOReactorException e) {
            throw new RuntimeException("Reactor " + options.getThreadPrefix() + "not set up correctly", e);
        }
        CacheConfig cacheConfig = CacheConfig.custom().setMaxCacheEntries(options.getMaxCacheEntries()).setSharedCache(false).setMaxObjectSize(options.getMaxCacheObjectSize()).setNeverCacheHTTP10ResponsesWithQueryString(false).build();
        this.nonCachingHttpClient = client;
        this.httpCacheStorage = new FlushableHttpCacheStorage(cacheConfig);
        this.httpClient = new CachingHttpAsyncClient((HttpAsyncClient)client, (HttpCacheStorage)this.httpCacheStorage, cacheConfig);
        this.callbackExecutor = this.httpClientOptions.getCallbackExecutor();
        this.nonCachingHttpClient.start();
        this.requestKiller.start();
    }

    private String getUserAgent(HttpClientOptions options) {
        return String.format("Atlassian HttpClient %s / %s-%s (%s) / %s", MavenUtils.getVersion("com.atlassian.httpclient", "atlassian-httpclient-api"), this.applicationProperties.getDisplayName(), this.applicationProperties.getVersion(), this.applicationProperties.getBuildNumber(), options.getUserAgent());
    }

    @Override
    public final ResponsePromise execute(DefaultRequest request) {
        try {
            return this.doExecute(request);
        }
        catch (Throwable t) {
            return ResponsePromises.toResponsePromise((Promise)Promises.rejected((Throwable)t, Response.class));
        }
    }

    private ResponsePromise doExecute(DefaultRequest request) {
        HttpGet op;
        this.httpClientOptions.getRequestPreparer().apply((Object)request);
        request.validate();
        request.freeze();
        long start = System.currentTimeMillis();
        String uri = request.getUri().toString();
        Request.Method method = request.getMethod();
        switch (method) {
            case GET: {
                op = new HttpGet(uri);
                break;
            }
            case POST: {
                op = new HttpPost(uri);
                break;
            }
            case PUT: {
                op = new HttpPut(uri);
                break;
            }
            case DELETE: {
                op = new HttpDelete(uri);
                break;
            }
            case OPTIONS: {
                op = new HttpOptions(uri);
                break;
            }
            case HEAD: {
                op = new HttpHead(uri);
                break;
            }
            case TRACE: {
                op = new HttpTrace(uri);
                break;
            }
            default: {
                throw new UnsupportedOperationException(method.toString());
            }
        }
        if (request.hasEntity()) {
            if (op instanceof HttpEntityEnclosingRequestBase) {
                ((HttpEntityEnclosingRequestBase)op).setEntity(request.getHttpEntity());
            } else {
                throw new UnsupportedOperationException("HTTP method " + method + " does not support sending an entity");
            }
        }
        for (Map.Entry entry : request.getHeaders().entrySet()) {
            op.setHeader((String)entry.getKey(), (String)entry.getValue());
        }
        this.requestKiller.registerRequest((AbortableHttpRequest)op, this.httpClientOptions.getRequestTimeout());
        return ResponsePromises.toResponsePromise((Promise)this.getPromiseHttpAsyncClient(request).execute((HttpUriRequest)op, (HttpContext)new BasicHttpContext()).fold((Function)new Function<Throwable, Response>((HttpRequestBase)op, start, request){
            final /* synthetic */ HttpRequestBase val$op;
            final /* synthetic */ long val$start;
            final /* synthetic */ DefaultRequest val$request;
            {
                this.val$op = httpRequestBase;
                this.val$start = l;
                this.val$request = defaultRequest;
            }

            public Response apply(Throwable ex) {
                DefaultHttpClient.this.requestKiller.completedRequest((AbortableHttpRequest)this.val$op);
                long requestDuration = System.currentTimeMillis() - this.val$start;
                DefaultHttpClient.this.publishEvent(this.val$request, requestDuration, ex);
                throw Throwables.propagate((Throwable)ex);
            }
        }, (Function)new Function<HttpResponse, Response>((HttpRequestBase)op, start, request){
            final /* synthetic */ HttpRequestBase val$op;
            final /* synthetic */ long val$start;
            final /* synthetic */ DefaultRequest val$request;
            {
                this.val$op = httpRequestBase;
                this.val$start = l;
                this.val$request = defaultRequest;
            }

            public Response apply(HttpResponse httpResponse) {
                DefaultHttpClient.this.requestKiller.completedRequest((AbortableHttpRequest)this.val$op);
                long requestDuration = System.currentTimeMillis() - this.val$start;
                DefaultHttpClient.this.publishEvent(this.val$request, requestDuration, httpResponse.getStatusLine().getStatusCode());
                try {
                    return DefaultHttpClient.this.translate(httpResponse).freeze();
                }
                catch (IOException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        }));
    }

    private void publishEvent(Request request, long requestDuration, int statusCode) {
        if (HttpStatus.OK.code <= statusCode && statusCode < HttpStatus.MULTIPLE_CHOICES.code) {
            this.eventPublisher.publish((Object)new HttpRequestCompletedEvent(request.getUri().toString(), request.getMethod().name(), statusCode, requestDuration, (Map<String, String>)request.getAttributes()));
        } else {
            this.eventPublisher.publish((Object)new HttpRequestFailedEvent(request.getUri().toString(), request.getMethod().name(), statusCode, requestDuration, (Map<String, String>)request.getAttributes()));
        }
    }

    private void publishEvent(Request request, long requestDuration, Throwable ex) {
        this.eventPublisher.publish((Object)new HttpRequestFailedEvent(request.getUri().toString(), request.getMethod().name(), ex.toString(), requestDuration, (Map<String, String>)request.getAttributes()));
    }

    private PromiseHttpAsyncClient getPromiseHttpAsyncClient(DefaultRequest request) {
        return new SettableFuturePromiseHttpPromiseAsyncClient<C>((HttpAsyncClient)(request.isCacheDisabled() ? this.nonCachingHttpClient : this.httpClient), this.threadLocalContextManager, this.callbackExecutor);
    }

    private DefaultResponse translate(HttpResponse httpResponse) throws IOException {
        Header[] httpHeaders;
        StatusLine status = httpResponse.getStatusLine();
        DefaultResponse response = new DefaultResponse(this.httpClientOptions.getMaxEntitySize());
        response.setStatusCode(status.getStatusCode());
        response.setStatusText(status.getReasonPhrase());
        for (Header httpHeader : httpHeaders = httpResponse.getAllHeaders()) {
            response.setHeader(httpHeader.getName(), httpHeader.getValue());
        }
        HttpEntity entity = httpResponse.getEntity();
        if (entity != null) {
            response.setEntityStream(entity.getContent());
        }
        return response;
    }

    public void destroy() throws Exception {
        this.callbackExecutor.shutdown();
        this.requestKiller.stop();
        this.nonCachingHttpClient.close();
    }

    public void flushCacheByUriPattern(Pattern urlPattern) {
        this.httpCacheStorage.flushByUriPattern(urlPattern);
    }
}

