/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.http.mime;

import com.atlassian.http.mime.BrowserUtils;
import com.atlassian.http.mime.DownloadPolicy;
import com.atlassian.http.mime.DownloadPolicyProvider;
import com.atlassian.http.mime.HostileExtensionDetector;
import com.atlassian.http.mime.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentDispositionHeaderGuesser {
    private static final Logger log = LoggerFactory.getLogger(ContentDispositionHeaderGuesser.class);
    private static final String CONTENT_DISPOSITION_ATTACHMENT = "attachment";
    private static final String CONTENT_DISPOSITION_INLINE = "inline";
    private final DownloadPolicyProvider downloadPolicyProvider;
    private final HostileExtensionDetector hostileExtensionDetector;

    public ContentDispositionHeaderGuesser(DownloadPolicyProvider downloadPolicyProvider, HostileExtensionDetector hostileExtensionDetector) {
        this.downloadPolicyProvider = downloadPolicyProvider;
        this.hostileExtensionDetector = hostileExtensionDetector;
    }

    public String guessContentDispositionHeader(String fileName, String mimeContentType, String userAgent) {
        DownloadPolicy downloadPolicy = this.downloadPolicyProvider.getPolicy();
        boolean forceDownload = false;
        if (downloadPolicy.equals((Object)DownloadPolicy.Insecure)) {
            return CONTENT_DISPOSITION_INLINE;
        }
        if (downloadPolicy.equals((Object)DownloadPolicy.Secure)) {
            return CONTENT_DISPOSITION_ATTACHMENT;
        }
        forceDownload = this.isExecutableContent(fileName, mimeContentType);
        if (BrowserUtils.isIE(userAgent) && this.isTextContentType(mimeContentType)) {
            forceDownload = true;
        }
        if (forceDownload && log.isDebugEnabled()) {
            log.debug("\"" + fileName + "\" (" + mimeContentType + ") presents as executable content, forcing download.");
        }
        return forceDownload ? CONTENT_DISPOSITION_ATTACHMENT : CONTENT_DISPOSITION_INLINE;
    }

    public String guessMIME(String filename, String mimeContentType, String userAgent) {
        if (CONTENT_DISPOSITION_INLINE.equals(this.guessContentDispositionHeader(filename, mimeContentType, userAgent)) && this.isAllowInlineOverride(filename, mimeContentType, userAgent, this.downloadPolicyProvider.getPolicy())) {
            return "text/plain";
        }
        return mimeContentType;
    }

    public String guessMIME(String mimeContentType, boolean isBinaryFile) {
        boolean inSmartMode = this.downloadPolicyProvider.getPolicy().equals((Object)DownloadPolicy.Smart);
        if (!inSmartMode || isBinaryFile) {
            return mimeContentType;
        }
        return "text/plain";
    }

    private boolean isAllowInlineOverride(String fileName, String mimeContentType, String userAgent, DownloadPolicy downloadPolicy) {
        return downloadPolicy == DownloadPolicy.Smart && !BrowserUtils.isIE(userAgent) && this.isTextContentType(mimeContentType) && !StringUtils.isBlank(mimeContentType);
    }

    private boolean isTextContentType(String mimeContentType) {
        return this.hostileExtensionDetector.isTextContentType(mimeContentType);
    }

    private boolean isExecutableContent(String name, String mimeContentType) {
        return this.hostileExtensionDetector.isExecutableContent(name, mimeContentType);
    }
}

